/*-
******************************************************************************
******************************************************************************
**
**  ARCHIVE HEADER INFORMATION
**
**  @C-file{
**      FILENAME    = "vveparse.h",
**      VERSION     = "1.00",
**      DATE        = "",
**      TIME        = "",
**
**      AUTHOR      = "Niel Kempson",
**      ADDRESS     = "25 Whitethorn Drive
**                     Cheltenham
**                     GL52 5LL
**                     England",
**      TELEPHONE   = "+44-242 579105",
**      EMAIL       = "kempson@tex.ac.uk (Internet)",
**
**      SUPPORTED   = "yes",
**      ARCHIVED    = "tex.ac.uk, ftp.tex.ac.uk",
**      KEYWORDS    = "VVcode",
**
**      CODETABLE   = "ISO/ASCII",
**      CHECKSUM    = "51492 1481 5732 57976",
**
**      DOCSTRING   = { This file is part of VVcode.
**                  }
**  }
**
**  MODULE CONTENTS
**
**      chk_skipfrom            [tbs]
**      getv_characterset       -   
**      getv_decodeversion      -   
**      getv_format             -   
**      getv_mode               -   
**      getv_operatingsystem    -
**      getv_reclen             -   
**      getv_timestamp          -   
**      parse_begin_header      -   
**      rd_next_line            -   
**
**  COPYRIGHT
**
**      Written 1991-1992 by Niel Kempson <kempson@tex.ac.uk> who claims
**      no copyright over this program - you are free to use it as you wish.
**
**  CHANGE LOG
**
******************************************************************************
******************************************************************************
*/


/*
**----------------------------------------------------------------------------
** Forward declarations of functions in the file 'vveparse.c'
**----------------------------------------------------------------------------
*/
Boolean chk_skipfrom            ARGS ((CONST char *line_ptr,
                                    CONST Int16 part_needed,
                                    CONST char *hdrf_spec,
                                    CONST Header_Struct *skipfrom_hdr,
                                    File_Info *ip_file));
void getv_characterset          ARGS ((
                                    CONST Header_Struct *characterset_hdr,
                                    char **character_set));
void getv_decodeversion         ARGS ((
                                    CONST Header_Struct *decodeversion_hdr,
                                    Int16 *decode_version));
void getv_format                ARGS ((CONST Header_Struct *format_hdr,
                                    CONST char *format_str_array[],
                                    File_Info *vve_file));
void getv_mode                  ARGS ((CONST Header_Struct *mode_hdr,
                                    CONST char *format_str_array[],
                                    File_Info *vve_file));
void getv_operatingsystem       ARGS ((
                                    CONST Header_Struct *operatingsystem_hdr,
                                    char **operating_system));
void getv_reclen                ARGS ((CONST Header_Struct *reclen_hdr,
                                    File_Info *vve_file));
void getv_timestamp             ARGS ((CONST Header_Struct *timestamp_hdr,
                                    File_Info *vve_file));
void parse_begin_header         ARGS ((CONST char *line_ptr,
                                    CONST File_Info *ip_file,
                                    CONST Int16 decoding_type,
                                    Header_Struct *hdr_struct,
                                    char **hdr_file_spec));
char *rd_next_line              ARGS ((CONST Int32 max_chars,
                                    CONST char *vve_line_prefix,
                                    char *buffer,
                                    File_Info *ip_file,
                                    Int32 *byte_count));
