/*
 * Decompiled with CFR 0.152.
 */
package mill.main.buildgen;

import geny.Generator;
import geny.Writable;
import geny.Writable$;
import java.io.Serializable;
import mill.main.buildgen.BuildObject;
import mill.main.buildgen.IrArtifact;
import mill.main.buildgen.IrBaseInfo;
import mill.main.buildgen.IrBuild;
import mill.main.buildgen.IrDeveloper;
import mill.main.buildgen.IrLicense;
import mill.main.buildgen.IrPom;
import mill.main.buildgen.IrTrait;
import mill.main.buildgen.IrVersionControl;
import mill.main.buildgen.Node;
import mill.main.buildgen.Tree;
import mill.main.client.CodeGenConstants;
import mill.main.client.OutFiles;
import mill.moduledefs.Scaladoc;
import mill.runner.FileImportGraph$;
import mill.scalalib.CrossVersion;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.RelPath$;
import os.SegmentedPath;
import os.Source;
import os.Source$;
import os.SubPath;
import os.remove$;
import os.temp$;
import os.walk$stream$;
import os.write$;
import pprint.Util$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.mutable.Builder;
import scala.math.Ordering$String$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class BuildGenUtil$ {
    public static final BuildGenUtil$ MODULE$ = new BuildGenUtil$();
    private static final String linebreak = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |"));
    private static final String linebreak2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |\n      |"));
    private static final SubPath mavenMainResourceDir = (SubPath)os.package$.MODULE$.sub().$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"src", "main", "resources"}))));
    private static final SubPath mavenTestResourceDir = (SubPath)os.package$.MODULE$.sub().$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"src", "test", "resources"}))));
    private static final Map<String, String> testModulesByGroup = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("junit"), "TestModule.Junit4"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("org.junit.jupiter"), "TestModule.Junit5"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("org.testng"), "TestModule.TestNg"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("org.scalatest"), "TestModule.ScalaTest"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("org.specs2"), "TestModule.Specs2"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("com.lihaoyi"), "TestModule.UTest"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("org.scalameta"), "TestModule.Munit"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("com.disneystreaming"), "TestModule.Weaver"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("dev.zio"), "TestModule.ZioTest"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("org.scalacheck"), "TestModule.ScalaCheck")}));

    public String renderIrTrait(IrTrait value) {
        String zincWorker = (String)value.jvmId().fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)jvmId -> {
            String name = new StringBuilder(10).append(value.baseModule()).append("ZincWorker").toString();
            String setting = MODULE$.renderZincWorker(name);
            String typedef = MODULE$.renderZincWorker(name, (String)jvmId);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(22).append(setting).append("\n         |\n         |").append(typedef).toString()));
        });
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(163).append("trait ").append(value.baseModule()).append(" ").append(this.renderExtends(value.moduleSupertypes())).append(" {\n       |\n       |").append(this.renderJavacOptions(value.javacOptions(), this.renderJavacOptions$default$2())).append("\n       |\n       |").append(this.renderScalaVersion(value.scalaVersion(), this.renderScalaVersion$default$2())).append("\n       |\n       |").append(this.renderScalacOptions(value.scalacOptions(), this.renderScalacOptions$default$2())).append("\n       |\n       |").append(this.renderPomSettings(this.renderIrPom(value.pomSettings()), this.renderPomSettings$default$2())).append("\n       |\n       |").append(this.renderPublishVersion(value.publishVersion(), this.renderPublishVersion$default$2())).append("\n       |\n       |").append(this.renderPublishProperties(value.publishProperties(), this.renderPublishProperties$default$2())).append("\n       |\n       |").append(this.renderRepositories(value.repositories(), this.renderRepositories$default$2())).append("\n       |\n       |").append(zincWorker).append("\n       |}").toString()));
    }

    public String renderIrPom(IrPom value) {
        if (value == null) {
            return "";
        }
        String mkLicenses = value.licenses().iterator().map((Function1<IrLicense, String> & Serializable)license -> MODULE$.renderLicense((IrLicense)license)).mkString("Seq(", ", ", ")");
        String mkDevelopers = value.developers().iterator().map((Function1<IrDeveloper, String> & Serializable)dev -> MODULE$.renderDeveloper((IrDeveloper)dev)).mkString("Seq(", ", ", ")");
        return new StringBuilder(23).append("PomSettings(").append(this.escape(value.description())).append(", ").append(this.escape(value.organization())).append(", ").append(this.escape(value.url())).append(", ").append(mkLicenses).append(", ").append(this.renderVersionControl(value.versionControl())).append(", ").append(mkDevelopers).append(")").toString();
    }

    @Scaladoc(value="/**\n   * @param baseInfo to compare with [[build]] and render the values only if they are different.\n   */")
    public String renderIrBuild(IrBuild build, IrBaseInfo baseInfo) {
        IrPom irPom;
        String string;
        IrTrait baseTrait = baseInfo.moduleTypedef();
        if (!build.hasTest()) {
            string = "";
        } else {
            String declare = this.renderTestModuleDecl(build.testModule(), build.testModuleMainType(), build.scopedDeps().testModule());
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(278).append(declare).append(" {\n           |\n           |").append(this.renderBomIvyDeps(build.scopedDeps().testBomIvyDeps())).append("\n           |\n           |").append(this.renderIvyDeps(build.scopedDeps().testIvyDeps())).append("\n           |\n           |").append(this.renderModuleDeps(build.scopedDeps().testModuleDeps())).append("\n           |\n           |").append(this.renderCompileIvyDeps(build.scopedDeps().testCompileIvyDeps())).append("\n           |\n           |").append(this.renderCompileModuleDeps(build.scopedDeps().testCompileModuleDeps())).append("\n           |\n           |").append(this.renderResources(build.testResources())).append("\n           |\n           |def testSandboxWorkingDir = false\n           |def testEnableWorkStealing = false\n           |}").toString()));
        }
        String testModuleTypedef = string;
        IrPom irPom2 = build.pomSettings();
        IrPom irPom3 = irPom = baseTrait != null ? baseTrait.pomSettings() : null;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(342).append(this.renderArtifactName(build.projectName(), build.dirs())).append("\n       |\n       |").append(this.renderJavacOptions(build.javacOptions(), baseTrait != null ? baseTrait.javacOptions() : (Seq)package$.MODULE$.Seq().empty())).append("\n       |\n       |").append(this.renderScalaVersion(build.scalaVersion(), baseTrait != null ? baseTrait.scalaVersion() : None$.MODULE$)).append("\n       |\n       |").append(this.renderScalacOptions(build.scalacOptions(), baseTrait != null ? baseTrait.scalacOptions() : None$.MODULE$)).append("\n       |\n       |").append(this.renderRepositories(build.repositories(), baseTrait != null ? baseTrait.repositories() : (Seq)package$.MODULE$.Seq().empty())).append("\n       |\n       |").append(this.renderBomIvyDeps(build.scopedDeps().mainBomIvyDeps())).append("\n       |\n       |").append(this.renderIvyDeps(build.scopedDeps().mainIvyDeps())).append("\n       |\n       |").append(this.renderModuleDeps(build.scopedDeps().mainModuleDeps())).append("\n       |\n       |").append(this.renderCompileIvyDeps(build.scopedDeps().mainCompileIvyDeps())).append("\n       |\n       |").append(this.renderCompileModuleDeps(build.scopedDeps().mainCompileModuleDeps())).append("\n       |\n       |").append(this.renderRunIvyDeps(build.scopedDeps().mainRunIvyDeps())).append("\n       |\n       |").append(this.renderRunModuleDeps(build.scopedDeps().mainRunModuleDeps())).append("\n       |\n       |").append((Object)((irPom2 == null ? irPom != null : !((Object)irPom2).equals(irPom)) ? this.renderPomSettings(this.renderIrPom(build.pomSettings()), this.renderPomSettings$default$2()) : "")).append("\n       |\n       |").append(this.renderPublishVersion(build.publishVersion(), baseTrait != null ? baseTrait.publishVersion() : null)).append("\n       |\n       |").append(this.renderPomPackaging(build.packaging())).append("\n       |\n       |").append((Object)(build.pomParentArtifact() == null ? "" : this.renderPomParentProject(this.renderArtifact(build.pomParentArtifact())))).append("\n       |\n       |").append(this.renderPublishProperties(Nil$.MODULE$, this.renderPublishProperties$default$2())).append("\n       |\n       |").append(this.renderResources(build.resources())).append("\n       |\n       |").append(this.renderPublishProperties(build.publishProperties(), this.renderPublishProperties$default$2())).append("\n       |\n       |").append(testModuleTypedef).toString()));
    }

    public SubPath buildFile(Seq<String> dirs2) {
        String name = dirs2.isEmpty() ? (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps(CodeGenConstants.rootBuildFileNames)) : (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps(CodeGenConstants.nestedBuildFileNames));
        return (SubPath)((SegmentedPath)os.package$.MODULE$.sub().$div(PathChunk$.MODULE$.SeqPathChunk(dirs2, (Function1<String, PathChunk> & Serializable)s -> PathChunk$.MODULE$.stringToPathChunk((String)s)))).$div(new PathChunk.StringPathChunk(name));
    }

    public SortedSet<String> renderImports(Option<String> baseModule, boolean isNested, int packagesSize, Seq<String> extraImports) {
        return (SortedSet)((SetOps)SortedSet$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mill._", "mill.javalib._", "mill.javalib.publish._"}), Ordering$String$.MODULE$)).$plus$plus(extraImports).$plus$plus((IterableOnce<Nothing$>)((Object)(isNested ? baseModule.map((Function1<String, String> & Serializable)name -> new StringBuilder(14).append("_root_.build_.").append((String)name).toString()) : (packagesSize > 1 ? new $colon$colon<Nothing$>((Nothing$)((Object)"$packages._"), Nil$.MODULE$) : None$.MODULE$))));
    }

    public Generator<Path> buildFiles(Path workspace) {
        Path path = workspace.$div(new PathChunk.StringPathChunk(OutFiles.out));
        return walk$stream$.MODULE$.apply(workspace, (Function1<Path, Object>)(Function1<Object, Object> & Serializable)o -> BoxesRunTime.boxToBoolean(path.equals(o)), walk$stream$.MODULE$.apply$default$3(), walk$stream$.MODULE$.apply$default$4(), walk$stream$.MODULE$.apply$default$5(), walk$stream$.MODULE$.apply$default$6()).filter((Function1<Path, Object> & Serializable)file -> BoxesRunTime.boxToBoolean(ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(CodeGenConstants.buildFileExtensions), file.ext())));
    }

    public String buildModuleFqn(Seq<String> dirs2) {
        return ((IterableOnce)dirs2.$plus$colon("build")).iterator().map((Function1<String, String> & Serializable)s -> FileImportGraph$.MODULE$.backtickWrap((String)s)).mkString(".");
    }

    public <Module, Key> Map<Key, String> buildModuleFqnMap(Generator<Node<Module>> input, Function1<Module, Key> key2) {
        return input.map((Function1<Node, Tuple2> & Serializable)node -> new Tuple2(key2.apply(node.value()), MODULE$.buildModuleFqn(node.dirs()))).toSeq().toMap($less$colon$less$.MODULE$.refl());
    }

    public Source renderBuildSource(Node<BuildObject> node) {
        String pkg = this.buildModuleFqn(node.dirs());
        BuildObject buildObject = node.value();
        if (buildObject == null) {
            throw new MatchError(buildObject);
        }
        SortedSet<String> imports = buildObject.imports();
        SortedMap<String, SortedMap<String, String>> companions = buildObject.companions();
        Seq<String> supertypes = buildObject.supertypes();
        String inner = buildObject.inner();
        String outer = buildObject.outer();
        Tuple5<SortedSet<String>, SortedMap<String, SortedMap<String, String>>, Seq<String>, String, String> tuple5 = new Tuple5<SortedSet<String>, SortedMap<String, SortedMap<String, String>>, Seq<String>, String, String>(imports, companions, supertypes, inner, outer);
        SortedSet<String> imports2 = tuple5._1();
        SortedMap<String, SortedMap<String, String>> companions2 = tuple5._2();
        Seq<String> supertypes2 = tuple5._3();
        String inner2 = tuple5._4();
        String outer2 = tuple5._5();
        String importStatements = imports2.iterator().map((Function1<String, String> & Serializable)x$2 -> new StringBuilder(7).append("import ").append((String)x$2).toString()).mkString(this.linebreak());
        String companionTypedefs = companions2.iterator().map((Function1<Tuple2, String> & Serializable)x0$1 -> {
            SortedMap vals;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (vals = (SortedMap)tuple2._2()).isEmpty()) {
                return "";
            }
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                SortedMap vals2 = (SortedMap)tuple2._2();
                String members = vals2.iterator().map((Function1<Tuple2, String> & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        return new StringBuilder(7).append("val ").append(k).append(" = ").append(v).toString();
                    }
                    throw new MatchError(tuple2);
                }).mkString(MODULE$.linebreak());
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(49).append("object ").append(name).append(" {\n           |\n           |").append(members).append("\n           |}").toString()));
            }
            throw new MatchError(tuple2);
        }).mkString(this.linebreak2());
        return Source$.MODULE$.WritableSource(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(136).append("package ").append(pkg).append("\n       |\n       |").append(importStatements).append("\n       |\n       |").append(companionTypedefs).append("\n       |\n       |object `package` ").append(this.renderExtends(supertypes2)).append(" {\n       |\n       |").append(inner2).append("\n       |}\n       |\n       |").append(outer2).append("\n       |").toString())), (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s));
    }

    public Tree<Node<BuildObject>> compactBuildTree(Tree<Node<BuildObject>> tree) {
        Predef$.MODULE$.println("compacting Mill build tree");
        return tree.transform((Function2<Node, IterableOnce, Tree> & Serializable)(node, children) -> {
            ObjectRef<BuildObject> module = ObjectRef.create((BuildObject)node.value());
            Builder unmerged = package$.MODULE$.Seq().newBuilder();
            children.iterator().foreach((Function1<Tree, Object> & Serializable)x0$1 -> {
                Tree tree = x0$1;
                if (tree != null) {
                    Node node = (Node)tree.node();
                    Seq seq = tree.children();
                    if (node != null) {
                        Option option;
                        Seq<String> seq2 = node.dirs();
                        BuildObject nested = (BuildObject)node.value();
                        if (seq2 != null && !(option = package$.MODULE$.$colon$plus().unapply(seq2)).isEmpty()) {
                            SeqOps seqOps;
                            String dir = (String)option.get()._2();
                            if (seq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0 && nested.outer().isEmpty()) {
                                SortedMap mergedCompanions = BuildGenUtil$.merge$1(((BuildObject)module$1.elem).companions(), nested.companions());
                                if (mergedCompanions == null) {
                                    return unmerged.$plus$eq(tree);
                                }
                                SortedSet mergedImports = (SortedSet)((BuildObject)module$1.elem).imports().$plus$plus(nested.imports());
                                String name = FileImportGraph$.MODULE$.backtickWrap(dir);
                                Seq supertypes = (Seq)nested.supertypes().filterNot((Function1<String, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(BuildGenUtil$.$anonfun$compactBuildTree$7(x$3)));
                                String mergedInner = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(107).append(((BuildObject)module$1.elem).inner()).append("\n                 |\n                 |object ").append(name).append(" ").append(MODULE$.renderExtends(supertypes)).append("  {\n                 |\n                 |").append(nested.inner()).append("\n                 |}").toString()));
                                BuildObject qual$1 = (BuildObject)module$1.elem;
                                SortedSet x$1 = mergedImports;
                                SortedMap x$2 = mergedCompanions;
                                String x$32 = mergedInner;
                                Seq<String> x$4 = qual$1.copy$default$3();
                                String x$5 = qual$1.copy$default$5();
                                module$1.elem = qual$1.copy(x$1, x$2, x$4, x$32, x$5);
                                return BoxedUnit.UNIT;
                            }
                        }
                    }
                }
                return unmerged.$plus$eq(tree);
            });
            Seq unmergedChildren = (Seq)unmerged.result();
            if (node.dirs().isEmpty()) {
                BuildObject qual$2 = (BuildObject)module.elem;
                SortedSet x$6 = (SortedSet)((BuildObject)module.elem).imports().filterNot((Function1<String, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.startsWith("$file")));
                SortedMap<String, SortedMap<String, String>> x$7 = qual$2.copy$default$2();
                Seq<String> x$8 = qual$2.copy$default$3();
                String x$9 = qual$2.copy$default$4();
                String x$10 = qual$2.copy$default$5();
                module.elem = qual$2.copy(x$6, x$7, x$8, x$9, x$10);
                if (unmergedChildren.isEmpty()) {
                    BuildObject qual$3 = (BuildObject)module.elem;
                    SortedSet x$11 = (SortedSet)((BuildObject)module.elem).imports().filterNot((Function1<String, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(BuildGenUtil$.$anonfun$compactBuildTree$9(x$5)));
                    SortedMap<String, SortedMap<String, String>> x$12 = qual$3.copy$default$2();
                    Seq<String> x$13 = qual$3.copy$default$3();
                    String x$14 = qual$3.copy$default$4();
                    String x$15 = qual$3.copy$default$5();
                    module.elem = qual$3.copy(x$11, x$12, x$13, x$14, x$15);
                }
            }
            BuildObject x$16 = (BuildObject)module.elem;
            Seq<String> x$17 = node.copy$default$1();
            return new Tree<Node<BuildObject>>(node.copy(x$17, x$16), unmergedChildren);
        });
    }

    public String escape(String value) {
        return Util$.MODULE$.literalize(value == null ? Predef$.MODULE$.wrapString("") : Predef$.MODULE$.wrapString(value), Util$.MODULE$.literalize$default$2());
    }

    public String escapeOption(String value) {
        if (value == null) {
            return "None";
        }
        return new StringBuilder(8).append("Some(\"").append(value).append("\")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String renderIvyString(String group2, String artifact, Option<CrossVersion> crossVersion, String version, String tpe, String classifier, IterableOnce<Tuple2<String, String>> excludes) {
        Option<Seq<String>> option;
        String string;
        String string2;
        String sepVersion;
        String sepArtifact;
        block19: {
            String string3;
            block18: {
                String string4;
                String string5;
                Option<CrossVersion> option2 = crossVersion;
                if (None$.MODULE$.equals(option2)) {
                    string5 = new StringBuilder(1).append(":").append(artifact).toString();
                } else {
                    if (!(option2 instanceof Some)) throw new MatchError(option2);
                    Some some = (Some)option2;
                    CrossVersion value = (CrossVersion)some.value();
                    CrossVersion crossVersion2 = value;
                    if (crossVersion2 instanceof CrossVersion.Constant) {
                        CrossVersion.Constant constant = (CrossVersion.Constant)crossVersion2;
                        String value2 = constant.value();
                        string5 = new StringBuilder(2).append(":").append(artifact).append("_").append(value2).toString();
                    } else if (crossVersion2 instanceof CrossVersion.Binary) {
                        string5 = new StringBuilder(2).append("::").append(artifact).toString();
                    } else {
                        if (!(crossVersion2 instanceof CrossVersion.Full)) throw new MatchError(crossVersion2);
                        string5 = new StringBuilder(3).append(":::").append(artifact).toString();
                    }
                }
                sepArtifact = string5;
                if (version == null) {
                    Predef$.MODULE$.println(new StringBuilder(90).append("assuming ").append(group2).append(":").append(artifact).append(" is a BOM dependency; if not, please specify version in the generated build file").toString());
                    string4 = "";
                } else {
                    string4 = new StringBuilder(1).append(":").append(version).toString();
                }
                sepVersion = string4;
                string3 = tpe;
                switch (string3 == null ? 0 : string3.hashCode()) {
                    case 0: {
                        if (string3 == null || "".equals(string3)) {
                            break;
                        }
                        break block18;
                    }
                    case 104987: {
                        if ("jar".equals(string3)) {
                            break;
                        }
                        break block18;
                    }
                    default: {
                        break block18;
                    }
                }
                string2 = "";
                break block19;
            }
            string2 = new StringBuilder(6).append(";type=").append(string3).toString();
        }
        String sepTpe = string2;
        String string6 = classifier;
        if (string6 == null ? true : "".equals(string6)) {
            string = "";
        } else if (string6 != null && !(option = new StringContext(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"${", "}"})).s().unapplySeq(string6)).isEmpty() && option.get() != null && ((SeqOps)option.get()).lengthCompare(1) == 0) {
            String v = (String)((SeqOps)option.get()).apply(0);
            Predef$.MODULE$.println(new StringBuilder(41).append("dropping classifier ${").append(v).append("} for dependency ").append(group2).append(":").append(artifact).append(":").append(version).toString());
            string = "";
        } else {
            string = new StringBuilder(12).append(";classifier=").append(string6).toString();
        }
        String sepClassifier = string;
        String sepExcludes = excludes.iterator().map((Function1<Tuple2, String> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String group2 = (String)tuple2._1();
                String artifact = (String)tuple2._2();
                return new StringBuilder(10).append(";exclude=").append(group2).append(":").append(artifact).toString();
            }
            throw new MatchError(tuple2);
        }).mkString();
        return new StringBuilder(5).append("ivy\"").append(group2).append(sepArtifact).append(sepVersion).append(sepTpe).append(sepClassifier).append(sepExcludes).append("\"").toString();
    }

    public Option<CrossVersion> renderIvyString$default$3() {
        return None$.MODULE$;
    }

    public String renderIvyString$default$4() {
        return null;
    }

    public String renderIvyString$default$5() {
        return null;
    }

    public String renderIvyString$default$6() {
        return null;
    }

    public IterableOnce<Tuple2<String, String>> renderIvyString$default$7() {
        return package$.MODULE$.Seq().empty();
    }

    public boolean isBom(Tuple3<String, String, String> groupArtifactVersion) {
        return groupArtifactVersion._2().endsWith("-bom");
    }

    public boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public String linebreak() {
        return linebreak;
    }

    public String linebreak2() {
        return linebreak2;
    }

    public SubPath mavenMainResourceDir() {
        return mavenMainResourceDir;
    }

    public SubPath mavenTestResourceDir() {
        return mavenTestResourceDir;
    }

    public String renderArtifact(IrArtifact artifact) {
        return new StringBuilder(14).append("Artifact(").append(this.escape(artifact.group())).append(", ").append(this.escape(artifact.id())).append(", ").append(this.escape(artifact.version())).append(")").toString();
    }

    public String renderDeveloper(IrDeveloper dev) {
        return new StringBuilder(19).append("Developer(").append(this.escape(dev.id())).append(", ").append(this.escape(dev.name())).append(", ").append(this.escape(dev.url())).append(", ").append(this.escapeOption(dev.organization())).append(", ").append(this.escapeOption(dev.organizationUrl())).append(")").toString();
    }

    public String renderExtends(Seq<String> supertypes) {
        Option option;
        SeqOps seqOps;
        SeqOps seqOps2;
        Seq<String> seq = supertypes;
        if (seq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0) == 0) {
            return "";
        }
        if (seq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            String head = (String)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return new StringBuilder(8).append("extends ").append(head).toString();
        }
        if (seq != null && !(option = package$.MODULE$.$plus$colon().unapply(seq)).isEmpty()) {
            String head = (String)option.get()._1();
            Seq<String> tail = option.get()._2();
            return tail.mkString(new StringBuilder(14).append("extends ").append(head).append(" with ").toString(), " with ", "");
        }
        throw new MatchError(seq);
    }

    public String renderLicense(IrLicense license) {
        return new StringBuilder(19).append("License(").append(this.escape(license.id())).append(", ").append(this.escape(license.name())).append(", ").append(this.escape(license.url())).append(", ").append(license.isOsiApproved()).append(", ").append(license.isFsfLibre()).append(", ").append(this.escape(license.distribution())).append(")").toString();
    }

    public String renderVersionControl(IrVersionControl vc) {
        return new StringBuilder(22).append("VersionControl(").append(this.escapeOption(vc.url())).append(", ").append(this.escapeOption(vc.connection())).append(", ").append(this.escapeOption(vc.devConnection())).append(", ").append(this.escapeOption(vc.tag())).append(")").toString();
    }

    public String renderZincWorker(String moduleName, String jvmId) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(69).append("object ").append(moduleName).append(" extends ZincWorkerModule {\n       |  def jvmId = \"").append(jvmId).append("\"\n       |}").toString()));
    }

    public String optional(String construct, IterableOnce<String> args) {
        return this.optional(new StringBuilder(1).append(construct).append("(").toString(), args, ",", ")");
    }

    public String optional(String start, IterableOnce<String> args, String sep, String end) {
        Iterator<String> itr = args.iterator();
        if (itr.isEmpty()) {
            return "";
        }
        return itr.mkString(start, sep, end);
    }

    public Option<String> renderSeqWithSuper(String defName, Seq<String> args, Seq<String> superArgs2, String elementType, Function1<String, String> transform2) {
        if (args.startsWith(superArgs2, args.startsWith$default$2())) {
            int superLength = superArgs2.length();
            if (args.length() == superLength) {
                return None$.MODULE$;
            }
            return new Some<String>(args.iterator().drop(superLength).map(transform2).mkString(new StringBuilder(16).append("super.").append(defName).append("() ++ Seq(").toString(), ",", ")"));
        }
        return new Some<String>(args.isEmpty() ? new StringBuilder(11).append("Seq.empty[").append(elementType).append("]").toString() : args.iterator().map(transform2).mkString("Seq(", ",", ")"));
    }

    public Seq<String> renderSeqWithSuper$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Option<String> renderSeqTargetDefWithSuper(String defName, Seq<String> args, Seq<String> superArgs2, String elementType, Function1<String, String> transform2) {
        return this.renderSeqWithSuper(defName, args, superArgs2, elementType, transform2).map((Function1<String, String> & Serializable)x$6 -> new StringBuilder(7).append("def ").append(defName).append(" = ").append((String)x$6).toString());
    }

    public Seq<String> renderSeqTargetDefWithSuper$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Option<String> renderSeqTaskDefWithSuper(String defName, Seq<String> args, Seq<String> superArgs2, String elementType, Function1<String, String> transform2) {
        return this.renderSeqWithSuper(defName, args, superArgs2, elementType, transform2).map((Function1<String, String> & Serializable)s -> new StringBuilder(21).append("def ").append(defName).append(" = Task.Anon { ").append((String)s).append(" }").toString());
    }

    public Seq<String> renderSeqTaskDefWithSuper$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Path scalafmtConfigFile() {
        return temp$.MODULE$.apply(Source$.MODULE$.WritableSource(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("version = \"3.8.4\"\n        |runner.dialect = scala213\n        |newlines.source=fold\n        |newlines.topLevelStatementBlankLines = [\n        |  {\n        |    blanks { before = 1 }\n        |  }\n        |]\n        |")), (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s)), temp$.MODULE$.apply$default$2(), temp$.MODULE$.apply$default$3(), temp$.MODULE$.apply$default$4(), temp$.MODULE$.apply$default$5(), temp$.MODULE$.apply$default$6());
    }

    public String renderArtifactName(String name, Seq<String> dirs2) {
        if (dirs2.nonEmpty()) {
            Object a = dirs2.last();
            String string = name;
            if (!(a != null ? !a.equals(string) : string != null)) {
                return "";
            }
        }
        return new StringBuilder(19).append("def artifactName = ").append(this.escape(name)).toString();
    }

    public String renderBomIvyDeps(IterableOnce<String> args) {
        return this.optional("def bomIvyDeps = super.bomIvyDeps() ++ Agg", args);
    }

    public String renderIvyDeps(IterableOnce<String> args) {
        return this.optional("def ivyDeps = super.ivyDeps() ++ Agg", args);
    }

    public String renderModuleDeps(IterableOnce<String> args) {
        return this.optional("def moduleDeps = super.moduleDeps ++ Agg", args);
    }

    public String renderCompileIvyDeps(IterableOnce<String> args) {
        return this.optional("def compileIvyDeps = super.compileIvyDeps() ++ Agg", args);
    }

    public String renderCompileModuleDeps(IterableOnce<String> args) {
        return this.optional("def compileModuleDeps = super.compileModuleDeps ++ Agg", args);
    }

    public String renderRunIvyDeps(IterableOnce<String> args) {
        return this.optional("def runIvyDeps = super.runIvyDeps() ++ Agg", args);
    }

    public String renderRunModuleDeps(IterableOnce<String> args) {
        return this.optional("def runModuleDeps = super.runModuleDeps ++ Agg", args);
    }

    public String renderJavacOptions(Seq<String> args, Seq<String> superArgs2) {
        return (String)this.renderSeqTargetDefWithSuper("javacOptions", args, superArgs2, "String", (Function1<String, String> & Serializable)value -> MODULE$.escape((String)value)).getOrElse((Function0<String> & Serializable)() -> "");
    }

    public Seq<String> renderJavacOptions$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public String renderScalaVersion(Option<String> arg2, Option<String> superArg) {
        Option<String> option = arg2;
        Option<String> option2 = superArg;
        if (option == null ? option2 != null : !option.equals(option2)) {
            return (String)arg2.fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)scalaVersion -> new StringBuilder(19).append("def scalaVersion = ").append(MODULE$.escape((String)scalaVersion)).toString());
        }
        return "";
    }

    public Option<String> renderScalaVersion$default$2() {
        return None$.MODULE$;
    }

    public String renderScalacOptions(Option<Seq<String>> args, Option<Seq<String>> superArgs2) {
        return (String)this.renderSeqTargetDefWithSuper("scalacOptions", (Seq)args.getOrElse((Function0<Seq> & Serializable)() -> (Seq)package$.MODULE$.Seq().empty()), (Seq)superArgs2.getOrElse((Function0<Seq> & Serializable)() -> (Seq)package$.MODULE$.Seq().empty()), "String", (Function1<String, String> & Serializable)value -> MODULE$.escape((String)value)).getOrElse((Function0<String> & Serializable)() -> "");
    }

    public Option<Seq<String>> renderScalacOptions$default$2() {
        return None$.MODULE$;
    }

    public String renderRepositories(Seq<String> args, Seq<String> superArgs2) {
        return (String)this.renderSeqTaskDefWithSuper("repositoriesTask", args, superArgs2, "coursier.Repository", (Function1<String, String> & Serializable)x -> Predef$.MODULE$.identity(x)).getOrElse((Function0<String> & Serializable)() -> "");
    }

    public Seq<String> renderRepositories$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public String renderResources(IterableOnce<SubPath> args) {
        return this.optional("def resources = Task.Sources { super.resources() ++ Seq(", args.iterator().map((Function1<SubPath, String> & Serializable)sub -> new StringBuilder(26).append("PathRef(millSourcePath / ").append(MODULE$.escape(sub.toString())).append(")").toString()), ", ", ") }");
    }

    public String renderPomPackaging(String packaging) {
        if (this.isNullOrEmpty(packaging) || "jar".equals(packaging)) {
            return "";
        }
        String pkg = "pom".equals(packaging) ? "PackagingType.Pom" : this.escape(packaging);
        return new StringBuilder(23).append("def pomPackagingType = ").append(pkg).toString();
    }

    public String renderPomParentProject(String artifact) {
        if (this.isNullOrEmpty(artifact)) {
            return "";
        }
        return new StringBuilder(29).append("def pomParentProject = Some(").append(artifact).append(")").toString();
    }

    public String renderPomSettings(String arg2, String superArg) {
        if (this.isNullOrEmpty(arg2)) {
            return "";
        }
        return new StringBuilder(18).append("def pomSettings = ").append(arg2).toString();
    }

    public String renderPomSettings$default$2() {
        return null;
    }

    public String renderPublishVersion(String arg2, String superArg) {
        String string = arg2;
        String string2 = superArg;
        if (string == null ? string2 != null : !string.equals(string2)) {
            if (this.isNullOrEmpty(arg2)) {
                return "";
            }
            return new StringBuilder(21).append("def publishVersion = ").append(this.escape(arg2)).toString();
        }
        return "";
    }

    public String renderPublishVersion$default$2() {
        return null;
    }

    public String renderPublishProperties(Seq<Tuple2<String, String>> args, Seq<Tuple2<String, String>> superArgs2) {
        Iterator<String> tuples = args.iterator().map((Function1<Tuple2, String> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(4).append("(").append(MODULE$.escape(k)).append(", ").append(MODULE$.escape(v)).append(")").toString();
            }
            throw new MatchError(tuple2);
        });
        return this.optional("def publishProperties = super.publishProperties() ++ Map", tuples);
    }

    public Seq<Tuple2<String, String>> renderPublishProperties$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public String renderZincWorker(String moduleName) {
        return new StringBuilder(40).append("def zincWorker = mill.define.ModuleRef(").append(moduleName).append(")").toString();
    }

    public Map<String, String> testModulesByGroup() {
        return testModulesByGroup;
    }

    public void writeBuildObject(Tree<Node<BuildObject>> tree) {
        Seq<Node<BuildObject>> nodes = tree.nodes(tree.nodes$default$1()).toSeq();
        Predef$.MODULE$.println(new StringBuilder(29).append("generated ").append(nodes.length()).append(" Mill build file(s)").toString());
        Predef$.MODULE$.println("removing existing Mill build files");
        Path workspace = os.package$.MODULE$.pwd();
        this.buildFiles(workspace).foreach((Function1<Path, BoxedUnit>)(Function1<Path, Object> & Serializable)target -> {
            remove$.MODULE$.apply(target);
            return BoxedUnit.UNIT;
        });
        nodes.foreach((Function1<Node, Object> & Serializable)node -> {
            BuildGenUtil$.$anonfun$writeBuildObject$2(workspace, node);
            return BoxedUnit.UNIT;
        });
    }

    public String renderTestModuleDecl(String testModule, String testModuleMainType, Option<String> testModuleExtraType) {
        String name = FileImportGraph$.MODULE$.backtickWrap(testModule);
        Option<String> option = testModuleExtraType;
        if (option instanceof Some) {
            Some some = (Some)option;
            String supertype = (String)some.value();
            return new StringBuilder(22).append("object ").append(name).append(" extends ").append(testModuleMainType).append(" with ").append(supertype).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return new StringBuilder(15).append("trait ").append(name).append(" extends ").append(testModuleMainType).toString();
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$compactBuildTree$3(SortedMap parentConstants$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String v;
            String k = (String)tuple2._1();
            String string = v = (String)tuple2._2();
            Object V1 = parentConstants$1.getOrElse(k, (Function0<String> & Serializable)() -> v);
            return string == null ? V1 != null : !string.equals(V1);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$compactBuildTree$1(ObjectRef mergedParentCompanions$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String objectName = (String)tuple2._1();
            SortedMap childConstants = (SortedMap)tuple2._2();
            SortedMap parentConstants = (SortedMap)((SortedMap)mergedParentCompanions$1.elem).getOrElse(objectName, (Function0<Null$> & Serializable)() -> null);
            if (parentConstants == null) {
                mergedParentCompanions$1.elem = (SortedMap)((SortedMap)mergedParentCompanions$1.elem).$plus(tuple2);
                return;
            }
            if (childConstants.exists((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(BuildGenUtil$.$anonfun$compactBuildTree$3(parentConstants, x0$2)))) {
                throw new NonLocalReturnControl<Object>(nonLocalReturnKey1$1, null);
            }
            mergedParentCompanions$1.elem = (SortedMap)((SortedMap)mergedParentCompanions$1.elem).$plus(new Tuple2(objectName, parentConstants.$plus$plus(childConstants)));
            return;
        }
        throw new MatchError(tuple2);
    }

    private static final SortedMap merge$1(SortedMap parentCompanions, SortedMap childCompanions) {
        SortedMap sortedMap;
        Object object = new Object();
        try {
            ObjectRef<SortedMap> mergedParentCompanions = ObjectRef.create(parentCompanions);
            childCompanions.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                BuildGenUtil$.$anonfun$compactBuildTree$1(mergedParentCompanions, object, x0$1);
                return BoxedUnit.UNIT;
            });
            sortedMap = (SortedMap)mergedParentCompanions.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                sortedMap = (SortedMap)ex.value();
            }
            throw ex;
        }
        return sortedMap;
    }

    public static final /* synthetic */ boolean $anonfun$compactBuildTree$7(String x$3) {
        String string = x$3;
        String string2 = "RootModule";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$compactBuildTree$9(String x$5) {
        String string = x$5;
        String string2 = "$packages._";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$writeBuildObject$2(Path workspace$1, Node node) {
        SubPath file = MODULE$.buildFile(node.dirs());
        Source source = MODULE$.renderBuildSource(node);
        Predef$.MODULE$.println(new StringBuilder(27).append("writing Mill build file to ").append(file).toString());
        write$.MODULE$.apply(workspace$1.$div(PathChunk$.MODULE$.SubPathChunk(file)), source, write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
    }

    private BuildGenUtil$() {
    }
}

