/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.netbeans.installer.downloader.DownloadManager;
import org.netbeans.installer.downloader.connector.MyProxy;
import org.netbeans.installer.downloader.connector.MyProxyType;
import org.netbeans.installer.downloader.connector.URLConnector;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.helper.swing.NbiButton;
import org.netbeans.installer.utils.helper.swing.NbiCheckBox;
import org.netbeans.installer.utils.helper.swing.NbiDialog;
import org.netbeans.installer.utils.helper.swing.NbiLabel;
import org.netbeans.installer.utils.helper.swing.NbiTextField;
import org.netbeans.installer.utils.helper.swing.NbiTextPane;

public class ProxySettingsDialog
extends NbiDialog {
    private URLConnector connector = URLConnector.getConnector();
    private NbiTextPane messagePane;
    private NbiLabel proxyHostLabel;
    private NbiTextField proxyHostField;
    private NbiLabel proxyPortLabel;
    private NbiTextField proxyPortField;
    private NbiLabel ignoreListLabel;
    private NbiTextField ignoreListField;
    private NbiCheckBox useProxyCheckBox;
    private NbiButton applyButton;
    private NbiButton closeButton;

    public ProxySettingsDialog() {
        this.initComponents();
    }

    public void execute() {
        this.setVisible(true);
        while (this.isVisible()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                ErrorManager.notifyDebug("Interrupted", e);
            }
        }
    }

    private void initComponents() {
        Proxy proxy = this.connector.getProxy(MyProxyType.HTTP);
        InetSocketAddress address = proxy != null ? (InetSocketAddress)proxy.address() : null;
        this.setTitle("Connectivity Problems");
        this.setLayout(new GridBagLayout());
        this.messagePane = new NbiTextPane();
        this.messagePane.setText("The installation wizard failed to connect to the registry server. Most likely this is caused by proxies misconfiguration. Please check the HTTP proxy settings below and click Apply to change them. Click Close to exit the installer.");
        this.useProxyCheckBox = new NbiCheckBox();
        this.useProxyCheckBox.setText("Use proxy");
        this.useProxyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ProxySettingsDialog.this.useProxyCheckBox.isSelected()) {
                    ProxySettingsDialog.this.proxyHostField.setEnabled(true);
                    ProxySettingsDialog.this.proxyPortField.setEnabled(true);
                    ProxySettingsDialog.this.ignoreListField.setEnabled(true);
                } else {
                    ProxySettingsDialog.this.proxyHostField.setEnabled(false);
                    ProxySettingsDialog.this.proxyPortField.setEnabled(false);
                    ProxySettingsDialog.this.ignoreListField.setEnabled(false);
                }
            }
        });
        this.useProxyCheckBox.setSelected(this.connector.getUseProxy());
        this.proxyHostField = new NbiTextField();
        if (address != null) {
            this.proxyHostField.setText(address.getHostName());
        }
        this.proxyHostLabel = new NbiLabel();
        this.proxyHostLabel.setLabelFor(this.proxyHostField);
        this.proxyHostLabel.setText("Host:");
        this.proxyPortField = new NbiTextField();
        if (address != null) {
            this.proxyPortField.setText(Integer.toString(address.getPort()));
        }
        this.proxyPortLabel = new NbiLabel();
        this.proxyPortLabel.setLabelFor(this.proxyPortField);
        this.proxyPortLabel.setText("Port:");
        this.ignoreListField = new NbiTextField();
        if (address != null) {
            this.ignoreListField.setText(StringUtils.asString(this.connector.getByPassHosts(), ","));
        }
        this.ignoreListLabel = new NbiLabel();
        this.ignoreListLabel.setLabelFor(this.ignoreListField);
        this.ignoreListLabel.setText("Bypass proxy for:");
        this.applyButton = new NbiButton();
        this.applyButton.setText("&Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Proxy proxy = null;
                if (ProxySettingsDialog.this.useProxyCheckBox.isSelected()) {
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxySettingsDialog.this.proxyHostField.getText(), Integer.parseInt(ProxySettingsDialog.this.proxyPortField.getText())));
                    ProxySettingsDialog.this.connector.addProxy(new MyProxy(proxy, MyProxyType.HTTP));
                    ProxySettingsDialog.this.connector.clearByPassList();
                    for (String host : StringUtils.asList(ProxySettingsDialog.this.ignoreListField.getText(), ",")) {
                        ProxySettingsDialog.this.connector.addByPassHost(host);
                    }
                }
                ProxySettingsDialog.this.connector.setUseProxy(ProxySettingsDialog.this.useProxyCheckBox.isSelected());
                ProxySettingsDialog.this.setVisible(false);
            }
        });
        this.closeButton = new NbiButton();
        this.closeButton.setText("&Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DownloadManager.getInstance().getFinishHandler().criticalExit();
            }
        });
        if (this.useProxyCheckBox.isSelected()) {
            this.proxyHostField.setEnabled(true);
            this.proxyPortField.setEnabled(true);
            this.ignoreListField.setEnabled(true);
        } else {
            this.proxyHostField.setEnabled(false);
            this.proxyPortField.setEnabled(false);
            this.ignoreListField.setEnabled(false);
        }
        this.add((Component)this.messagePane, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 21, 2, new Insets(11, 11, 0, 11), 0, 0));
        this.add((Component)this.useProxyCheckBox, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 21, 2, new Insets(11, 11, 0, 11), 0, 0));
        this.add((Component)this.proxyHostLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 11, 0, 0), 0, 0));
        this.add((Component)this.proxyHostField, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 11), 0, 0));
        this.add((Component)this.proxyPortLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 11, 0, 0), 0, 0));
        this.add((Component)this.proxyPortField, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 11), 0, 0));
        this.add((Component)this.ignoreListLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 11, 0, 0), 0, 0));
        this.add((Component)this.ignoreListField, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 11), 0, 0));
        this.add((Component)this.applyButton, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 14, 0, new Insets(17, 11, 11, 0), 0, 0));
        this.add((Component)this.closeButton, new GridBagConstraints(2, 5, 1, 1, 0.0, 1.0, 14, 0, new Insets(17, 6, 11, 11), 0, 0));
    }
}

