/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.CellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public class CellEditorSupport {
    private final CellEditor editor;
    private final Set<CellEditorListener> listeners;

    public CellEditorSupport(CellEditor editor) {
        this.editor = editor;
        this.listeners = new LinkedHashSet<CellEditorListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CellEditorListener> getListeners() {
        CellEditorSupport cellEditorSupport = this;
        synchronized (cellEditorSupport) {
            return new ArrayList<CellEditorListener>(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCellEditorListener(CellEditorListener l) {
        CellEditorSupport cellEditorSupport = this;
        synchronized (cellEditorSupport) {
            if (l != null) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCellEditorListener(CellEditorListener l) {
        CellEditorSupport cellEditorSupport = this;
        synchronized (cellEditorSupport) {
            if (l != null) {
                this.listeners.remove(l);
            }
        }
    }

    public final void fireEditingCanceled() {
        for (CellEditorListener listener : this.getListeners()) {
            listener.editingCanceled(new ChangeEvent(this.editor));
        }
    }

    public final void fireEditingStopped() {
        for (CellEditorListener listener : this.getListeners()) {
            listener.editingStopped(new ChangeEvent(this.editor));
        }
    }
}

