/*
 *  linux/arch/arm/mach-dw/gpio-setup.h
 *
 *  Copyright (C) 2011, DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MACH_DMW_GPIO_SETUP_H
#define __MACH_DMW_GPIO_SETUP_H

#define GPIO_DISABLE	-1
#define GPIO_IN		0
#define GPIO_OUT_LOW	1
#define GPIO_OUT_HIGH	2

#define GPIO_PULL_DISABLE	-1
#define GPIO_PULL_DOWN		0
#define GPIO_PULL_UP		1

struct gpio_setup_t {
	unsigned char gpio;
	signed char state : 3;
	signed char pull  : 2;
};

#define GPIO_SETUP(_port, _idx, _state, _pull)	\
	{					\
		.gpio = GPIO_PORT##_port(_idx),	\
		.state = (_state),		\
		.pull = (_pull),		\
	}

__init void dmw_gpio_setup(struct gpio_setup_t *setup, unsigned int size);

#endif
