/*
 *  linux/arch/arm/mach-dmw/include/mach/irqs.h
 *
 *  Copyright (C) 2010 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MACH_IRQS_H
#define __MACH_IRQS_H

#define DMW_PLICU_NR_IRQS		64

/* leave some room for the DP52 interrupts */
#define NR_IRQS				DMW_PLICU_NR_IRQS + 16

/* all interrupts can be FIQs */
#define FIQ_START			0

int dmw_trigger_sw_irq(unsigned int irq);
int dmw_set_irq_fiq(unsigned int irq, unsigned int type);

#define DMW_IID_CORTEX			0
#define DMW_IID_DBM			1
#define DMW_IID_USB1OTG_SOF_PULSE	2
#define DMW_IID_USB1OTG_MC_NINT		3
#define DMW_IID_KEYPAD			4
#define DMW_IID_RESERVED2		5
#define DMW_IID_CSS_NORMAL_INTERRUPT	6
#define DMW_IID_SECURITY_ACCELERATOR	7
#define DMW_IID_DRAM_CONTROLLER		8
#define DMW_IID_GPU			9
#define DMW_IID_VIDEO_ENCODER		10
#define DMW_IID_VIDEO_DECODER		11
#define DMW_IID_CIU			12
#define DMW_IID_SLAVE_MII		13
#define DMW_IID_LCD_CONTROLLER		14
#define DMW_IID_SW1			15
#define DMW_IID_MEMORY_STICK_CONTROLLER	16
#define DMW_IID_SDMMC_CONTROLLER	17
#define DMW_IID_OSDM			18
#define DMW_IID_SEC			19
#define DMW_IID_GDMAC_ERROR		20
#define DMW_IID_GDMAC_DMA_DONE		21
#define DMW_IID_FLASH_CONTROLLER	22
#define DMW_IID_8023MAC			23
#define DMW_IID_EXTERNAL_REQUEST_0	24
#define DMW_IID_EXTERNAL_REQUEST_1	25
#define DMW_IID_EXTERNAL_REQUEST_2	26
#define DMW_IID_EXTERNAL_REQUEST_3	27
#define DMW_IID_EXTERNAL_REQUEST_4	28
#define DMW_IID_EXTERNAL_REQUEST_5	29
#define DMW_IID_EXTERNAL_REQUEST_6	30
#define DMW_IID_SW2			31
#define DMW_IID_EXTERNAL_REQUEST_7	32
#define DMW_IID_EXTERNAL_REQUEST_8	33
#define DMW_IID_EXTERNAL_REQUEST_9	34
#define DMW_IID_EXTERNAL_REQUEST_10	35
#define DMW_IID_EXTERNAL_REQUEST_11	36
#define DMW_IID_EXTERNAL_REQUEST_12	37
#define DMW_IID_EXTERNAL_REQUEST_13	38
#define DMW_IID_EXTERNAL_REQUEST_14	39
#define DMW_IID_EXTERNAL_REQUEST_15	40
#define DMW_IID_RTC			41
#define DMW_IID_I2C2			42
#define DMW_IID_I2C1			43
#define DMW_IID_SPI2			44
#define DMW_IID_SPI1			45
#define DMW_IID_TIMER4			46
#define DMW_IID_SW3			47
#define DMW_IID_TIMER3			48
#define DMW_IID_TIMER2			49
#define DMW_IID_TIMER1			50
#define DMW_IID_WIFI_MAC		51
#define DMW_IID_MAC			52
#define DMW_IID_UART3			53
#define DMW_IID_UART2			54
#define DMW_IID_UART1			55
#define DMW_IID_USB2OTG_SOF_PULSE	56
#define DMW_IID_USB2OTG_MC_NINT		57
#define DMW_IID_TDM3			58
#define DMW_IID_TDM2			59
#define DMW_IID_TDM1			60
#define DMW_IID_PACP			61
#define DMW_IID_WD			62
#define DMW_IID_SW4			63



#define DMW_IRQ_STRINGS \
	"cortex", \
	"dbm", \
	"usb1otg_sof_pulse", \
	"usb1otg_mc_nint", \
	"keypad", \
	"reserved2", \
	"css_normal_interrupt", \
	"security_accelerator", \
	"dram_controller", \
	"gpu", \
	"video_encoder", \
	"video_decoder", \
	"ciu", \
	"slave_mii", \
	"lcd_controller", \
	"sw1", \
	"memory_stick_controller", \
	"sdmmc_controller", \
	"osdm", \
	"sec", \
	"gdmac_error", \
	"gdmac_dma_done", \
	"flash_controller", \
	"8023mac", \
	"external_request_0", \
	"external_request_1", \
	"external_request_2", \
	"external_request_3", \
	"external_request_4", \
	"external_request_5", \
	"external_request_6", \
	"sw2", \
	"external_request_7", \
	"external_request_8", \
	"external_request_9", \
	"external_request_10", \
	"external_request_11", \
	"external_request_12", \
	"external_request_13", \
	"external_request_14", \
	"external_request_15", \
	"rtc", \
	"i2c2", \
	"i2c1", \
	"spi2", \
	"spi1", \
	"timer4", \
	"sw3", \
	"timer3", \
	"timer2", \
	"timer1", \
	"wifi_mac", \
	"mac", \
	"uart3", \
	"uart2", \
	"uart1", \
	"usb2otg_sof_pulse", \
	"usb2otg_mc_nint", \
	"tdm3", \
	"tdm2", \
	"tdm1", \
	"pacp", \
	"wd", \
	"sw4" 
#endif
