// TODO: limitation: only one sensor instance of any kind (because of global data structures)
/*
 * drivers/media/video/ov5642.c
 *
 * ov5642 sensor driver
 *
 *
 * Copyright (C) 2012 DSPG.
 *
 * Leverage ov5642.c
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2. This program is licensed "as is" without any warranty of any
 * kind, whether express or implied.
 */

#include <linux/io.h>
#include <linux/i2c.h>
#include <linux/delay.h>
#include <media/v4l2-int-device.h>
#include <media/ov5642.h>
#include <linux/dma-mapping.h> /*For page align*/
#include <media/dmw96ciu.h>
#include <mach/hardware.h>
#include <mach/camera.h>

/**********************************
 * definitions
 **********************************/

#define OV5642_DRIVER_NAME  "ov5642"
#define MOD_NAME "OV5642: "

#define OV5642_I2C_ADDR (0x78 >> 1)

#define I2C_M_WR 0

#define OV5642_PIDH 0x300A
#define OV5642_PIDL 0x300B

/* High byte of product ID */
#define OV5642_PIDH_MAGIC      0x56
/* Low byte of product ID  */
#define OV5642_PIDL_MAGIC      0x42

#define OV5642_USE_XCLKA       0
#define OV5642_USE_XCLKB       1

#define OV5642_CSI2_VIRTUAL_ID 0x1

/* FPS Capabilities */
#define OV5642_MIN_FPS                 3
#define OV5642_DEF_FPS                 15
#define OV5642_MAX_FPS                 30

#define OV5642_MIN_BRIGHT              0
#define OV5642_MAX_BRIGHT              6
#define OV5642_DEF_BRIGHT              0
#define OV5642_BRIGHT_STEP             1

#define OV5642_DEF_CONTRAST            0
#define OV5642_MIN_CONTRAST            0
#define OV5642_MAX_CONTRAST            6
#define OV5642_CONTRAST_STEP           1

#define OV5642_DEF_COLOR               0
#define OV5642_MIN_COLOR               0
#define OV5642_MAX_COLOR               2
#define OV5642_COLOR_STEP              1

#define OV5642_DEF_FLIP               	0

#define OV5642_DEF_MIRRO               	0

#define SENSOR_DETECTED                1
#define SENSOR_NOT_DETECTED    0

/* NOTE: Set this as 0 for enabling SoC mode */
#define OV5642_RAW_MODE        0

/* XCLK Frequency in Hz*/
#define OV5642_XCLK_MIN                24000000
#define OV5642_XCLK_MAX                24000000

#define OV5642_REG_TERM 0xFFFF /* terminating list entry for reg */
#define OV5642_VAL_TERM 0xFF   /* terminating list entry for val */

#define vidioc_int_s_reg_num (vidioc_int_priv_start_num + 1)
V4L2_INT_WRAPPER_1(s_reg, const struct v4l2_dbg_register, *);

#define vidioc_int_g_reg_num (vidioc_int_priv_start_num + 2)
V4L2_INT_WRAPPER_1(g_reg, const struct v4l2_dbg_register, *);

#define array_size( arr ) (sizeof( arr ) / sizeof( arr[0] ))

static dmw_camera_sensor_desc_t ov5642_sensor_desc;

/**********************************
 * data
 **********************************/

typedef struct ov5642_reg_s
{
	unsigned int  reg;
	unsigned char val;
} ov5642_reg_t;

enum ov5642_frameintervals_type
{
	OV5642_3_FPS,
	OV5642_7_5_FPS,
	OV5642_11_FPS,
	OV5642_15_FPS,
	OV5642_20_FPS,
	OV5642_25_FPS,
	OV5642_30_FPS,
};

typedef struct ov5642_mode_s
{
	/* resolution */
    unsigned long  		 width;
    unsigned long  		 height;

    /* mode name string */
    const char *   		 name;

    /* initialization registers */
    const ov5642_reg_t * reg_list;
    unsigned long  		 num_regs;

} ov5642_mode_t;

/**********************************
 * registers
 **********************************/

static const ov5642_reg_t ov5642_regs_mode_CIF[] =
{
/* 0 */ {0x3103,0x93},
/* 1 */ {0x3008,0x82},
/* 2 */ {0x3017,0x7f},
/* 3 */ {0x3018,0xfc},
/* 4 */ {0x3810,0xc2},
/* 5 */ {0x3615,0xf0},
/* 6 */ {0x1000,0x00},
/* 7 */ {0x3001,0x00},
/* 8 */ {0x3002,0x5c},
/* 9 */ {0x3003,0x00},
/* 10 */ {0x3004,0xff},
/* 11 */ {0x3005,0xff},
/* 12 */ {0x3006,0x43},
/* 13 */ {0x3007,0x37},
/* 14 */ {0x3011,0x08},
/* 15 */ {0x3010,0x10}, //0x10 lower clock by 7
/* 16 */ {0x460c,0x22},
/* 17 */ {0x3815,0x04},
/* 18 */ {0x370c,0xa0},
/* 19 */ {0x3602,0xfc},
/* 20 */ {0x3612,0xff},
/* 21 */ {0x3634,0xc0},
/* 22 */ {0x3613,0x00},
/* 23 */ {0x3605,0x7c},
/* 24 */ {0x3621,0x09},
/* 25 */ {0x3622,0x60},
/* 26 */ {0x3604,0x40},
/* 27 */ {0x3603,0xa7},
/* 28 */ {0x3603,0x27},
/* 29 */ {0x4000,0x21},
/* 30 */ {0x401d,0x22},
/* 31 */ {0x3600,0x54},
/* 32 */ {0x3605,0x04},
/* 33 */ {0x3606,0x3f},
/* 34 */ {0x3c01,0x80},
/* 35 */ {0x5000,0x4f},
/* 36 */ {0x5020,0x04},
/* 37 */ {0x5181,0x79},
/* 38 */ {0x5182,0x00},
/* 39 */ {0x5185,0x22},
/* 40 */ {0x5197,0x01},
/* 41 */ {0x5001,0xff},
/* 42 */ {0x5500,0x0a},
/* 43 */ {0x5504,0x00},
/* 44 */ {0x5505,0x7f},
/* 45 */ {0x5080,0x08},
/* 46 */ {0x300e,0x18},
/* 47 */ {0x4610,0x00},
/* 48 */ {0x471d,0x05},
/* 49 */ {0x4708,0x06},
/* 50 */ {0x3808,0x02},
/* 51 */ {0x3809,0x80},
/* 52 */ {0x380a,0x01},
/* 53 */ {0x380b,0xe0},
/* 54 */ {0x380e,0x07},
/* 55 */ {0x380f,0xd0},
/* 56 */ {0x501f,0x00},
/* 57 */ {0x5000,0x4f},
/* 58 */ {0x4300,0x32}, //changes from 0x30 to 0x32 for UYVY (CbCrY)
/* 59 */ {0x3503,0x07},
/* 60 */ {0x3501,0x73},
/* 61 */ {0x3502,0x80},
/* 62 */ {0x350b,0x00},
/* 63 */ {0x3503,0x07},
/* 64 */ {0x3824,0x11},
/* 65 */ {0x3501,0x1e},
/* 66 */ {0x3502,0x80},
/* 67 */ {0x350b,0x7f},
/* 68 */ {0x380c,0x0c},
/* 69 */ {0x380d,0x80},
/* 70 */ {0x380e,0x03},
/* 71 */ {0x380f,0xe8},
/* 72 */ {0x3a0d,0x04},
/* 73 */ {0x3a0e,0x03},
/* 74 */ {0x3818,0xc1},
/* 75 */ {0x3705,0xdb},
/* 76 */ {0x370a,0x81},
/* 77 */ {0x3801,0x80},
/* 78 */ {0x3621,0x87},
/* 79 */ {0x3801,0x50},
/* 80 */ {0x3803,0x08},
/* 81 */ {0x3827,0x08},
/* 82 */ {0x3810,0x40},
/* 83 */ {0x3804,0x05},
/* 84 */ {0x3805,0x00},
/* 85 */ {0x5682,0x05},
/* 86 */ {0x5683,0x00},
/* 87 */ {0x3806,0x03},
/* 88 */ {0x3807,0xc0},
/* 89 */ {0x5686,0x03},
/* 90 */ {0x5687,0xbc},
/* 91 */ {0x3a00,0x78},
/* 92 */ {0x3a1a,0x05},
/* 93 */ {0x3a13,0x30},
/* 94 */ {0x3a18,0x00},
/* 95 */ {0x3a19,0x7c},
/* 96 */ {0x3a08,0x12},
/* 97 */ {0x3a09,0xc0},
/* 98 */ {0x3a0a,0x0f},
/* 99 */ {0x3a0b,0xa0},
/* 100 */ {0x350c,0x07},
/* 101 */ {0x350d,0xd0},
/* 102 */ {0x3500,0x00},
/* 103 */ {0x3501,0x00},
/* 104 */ {0x3502,0x00},
/* 105 */ {0x350a,0x00},
/* 106 */ {0x350b,0x00},
/* 107 */ {0x3503,0x00},
/* 108 */ {0x528a,0x02},
/* 109 */ {0x528b,0x04},
/* 110 */ {0x528c,0x08},
/* 111 */ {0x528d,0x08},
/* 112 */ {0x528e,0x08},
/* 113 */ {0x528f,0x10},
/* 114 */ {0x5290,0x10},
/* 115 */ {0x5292,0x00},
/* 116 */ {0x5293,0x02},
/* 117 */ {0x5294,0x00},
/* 118 */ {0x5295,0x02},
/* 119 */ {0x5296,0x00},
/* 120 */ {0x5297,0x02},
/* 121 */ {0x5298,0x00},
/* 122 */ {0x5299,0x02},
/* 123 */ {0x529a,0x00},
/* 124 */ {0x529b,0x02},
/* 125 */ {0x529c,0x00},
/* 126 */ {0x529d,0x02},
/* 127 */ {0x529e,0x00},
/* 128 */ {0x529f,0x02},
/* 129 */ {0x3a0f,0x3c},
/* 130 */ {0x3a10,0x30},
/* 131 */ {0x3a1b,0x3c},
/* 132 */ {0x3a1e,0x30},
/* 133 */ {0x3a11,0x70},
/* 134 */ {0x3a1f,0x10},
/* 135 */ {0x3030,0x0b}, //was 0x2b bypass regulator
/* 136 */ {0x3a02,0x00},
/* 137 */ {0x3a03,0x7d},
/* 138 */ {0x3a04,0x00},
/*139*/ {0x3a14,0x00},
/*140*/ {0x3a15,0x7d},
/*141*/ {0x3a16,0x00},
/*142*/ {0x3a00,0x78},
/*143*/ {0x3a08,0x09},
/*144*/ {0x3a09,0x60},
/*145*/ {0x3a0a,0x07},
/*146*/ {0x3a0b,0xd0},
/*147*/ {0x3a0d,0x08},
/*148*/ {0x3a0e,0x06},
/*149*/ {0x5193,0x70},
/*150*/ {0x589b,0x04},
/*151*/ {0x589a,0xc5},
/*152*/ {0x401e,0x20},
/*153*/ {0x4001,0x42},
/*154*/ {0x401c,0x04},
/*155*/ {0x528a,0x01},
/*156*/ {0x528b,0x04},
/*157*/ {0x528c,0x08},
/*158*/ {0x528d,0x10},
/*159*/ {0x528e,0x20},
/*160*/ {0x528f,0x28},
/*161*/ {0x5290,0x30},
/*162*/ {0x5292,0x00},
/*163*/ {0x5293,0x01},
/*164*/ {0x5294,0x00},
/*165*/ {0x5295,0x04},
/*166*/ {0x5296,0x00},
/*167*/ {0x5297,0x08},
/*168*/ {0x5298,0x00},
/*169*/ {0x5299,0x10},
/*170*/ {0x529a,0x00},
/*171*/ {0x529b,0x20},
/*172*/ {0x529c,0x00},
/*173*/ {0x529d,0x28},
/*174*/ {0x529e,0x00},
/*175*/ {0x529f,0x30},
/*176*/ {0x5282,0x00},
/*177*/ {0x5300,0x00},
/*178*/ {0x5301,0x20},
/*179*/ {0x5302,0x00},
/*180*/ {0x5303,0x7c},
/*181*/ {0x530c,0x00},
/*182*/ {0x530d,0x0c},
/*183*/ {0x530e,0x20},
/*184*/ {0x530f,0x80},
/*185*/ {0x5310,0x20},
/*186*/ {0x5311,0x80},
/*187*/ {0x5308,0x20},
/*188*/ {0x5309,0x40},
/*189*/ {0x5304,0x00},
/*190*/ {0x5305,0x30},
/*191*/ {0x5306,0x00},
/*192*/ {0x5307,0x80},
/*193*/ {0x5314,0x08},
/*194*/ {0x5315,0x20},
/*195*/ {0x5319,0x30},
/*196*/ {0x5316,0x10},
/*197*/ {0x5317,0x00},
/*198*/ {0x5318,0x02},
/*199*/ {0x5380,0x01},
/*200*/ {0x5381,0x00},
/*201*/ {0x5382,0x00},
/*202*/ {0x5383,0x4e},
/*203*/ {0x5384,0x00},
/*204*/ {0x5385,0x0f},
/*205*/ {0x5386,0x00},
/*206*/ {0x5387,0x00},
/*207*/ {0x5388,0x01},
/*208*/ {0x5389,0x15},
/*209*/ {0x538a,0x00},
/*210*/ {0x538b,0x31},
/*211*/ {0x538c,0x00},
/*212*/ {0x538d,0x00},
/*213*/ {0x538e,0x00},
/*214*/ {0x538f,0x0f},
/*215*/ {0x5390,0x00},
/*216*/ {0x5391,0xab},
/*217*/ {0x5392,0x00},
/*218*/ {0x5393,0xa2},
/*219*/ {0x5394,0x08},
/*220*/ {0x5480,0x14},
/*221*/ {0x5481,0x21},
/*222*/ {0x5482,0x36},
/*223*/ {0x5483,0x57},
/*224*/ {0x5484,0x65},
/*225*/ {0x5485,0x71},
/*226*/ {0x5486,0x7d},
/*227*/ {0x5487,0x87},
/*228*/ {0x5488,0x91},
/*229*/ {0x5489,0x9a},
/*230*/ {0x548a,0xaa},
/*231*/ {0x548b,0xb8},
/*232*/ {0x548c,0xcd},
/*233*/ {0x548d,0xdd},
/*234*/ {0x548e,0xea},
/*235*/ {0x548f,0x1d},
/*236*/ {0x5490,0x05},
/*237*/ {0x5491,0x00},
/*238*/ {0x5492,0x04},
/*239*/ {0x5493,0x20},
/*240*/ {0x5494,0x03},
/*241*/ {0x5495,0x60},
/*242*/ {0x5496,0x02},
/*243*/ {0x5497,0xb8},
/*244*/ {0x5498,0x02},
/*245*/ {0x5499,0x86},
/*246*/ {0x549a,0x02},
/*247*/ {0x549b,0x5b},
/*248*/ {0x549c,0x02},
/*249*/ {0x549d,0x3b},
/*250*/ {0x549e,0x02},
/*251*/ {0x549f,0x1c},
/*252*/ {0x54a0,0x02},
/*253*/ {0x54a1,0x04},
/*254*/ {0x54a2,0x01},
/*255*/ {0x54a3,0xed},
/*256*/ {0x54a4,0x01},
/*257*/ {0x54a5,0xc5},
/*258*/ {0x54a6,0x01},
/*259*/ {0x54a7,0xa5},
/*260*/ {0x54a8,0x01},
/*261*/ {0x54a9,0x6c},
/*262*/ {0x54aa,0x01},
/*263*/ {0x54ab,0x41},
/*264*/ {0x54ac,0x01},
/*265*/ {0x54ad,0x20},
/*266*/ {0x54ae,0x00},
/*267*/ {0x54af,0x16},
/*268*/ {0x54b0,0x01},
/*269*/ {0x54b1,0x20},
/*270*/ {0x54b2,0x00},
/*271*/ {0x54b3,0x10},
/*272*/ {0x54b4,0x00},
/*273*/ {0x54b5,0xf0},
/*274*/ {0x54b6,0x00},
/*275*/ {0x54b7,0xdf},
/*276*/ {0x5402,0x3f},
/*277*/ {0x5403,0x00},
/*278*/ {0x3406,0x00},
/*279*/ {0x5180,0xff},
/*280*/ {0x5181,0x52},
/*281*/ {0x5182,0x11},
/*282*/ {0x5183,0x14},
/*283*/ {0x5184,0x25},
/*284*/ {0x5185,0x24},
/*285*/ {0x5186,0x06},
/*286*/ {0x5187,0x08},
/*287*/ {0x5188,0x08},
/*288*/ {0x5189,0x7c},
/*289*/ {0x518a,0x60},
/*290*/ {0x518b,0xb2},
/*291*/ {0x518c,0xb2},
/*292*/ {0x518d,0x44},
/*293*/ {0x518e,0x3d},
/*294*/ {0x518f,0x58},
/*295*/ {0x5190,0x46},
/*296*/ {0x5191,0xf8},
/*297*/ {0x5192,0x04},
/*298*/ {0x5193,0x70},
/*299*/ {0x5194,0xf0},
/*300*/ {0x5195,0xf0},
/*301*/ {0x5196,0x03},
/*302*/ {0x5197,0x01},
/*303*/ {0x5198,0x04},
/*304*/ {0x5199,0x12},
/*305*/ {0x519a,0x04},
/*306*/ {0x519b,0x00},
/*307*/ {0x519c,0x06},
/*308*/ {0x519d,0x82},
/*309*/ {0x519e,0x00}, //
/*310*/ {0x5025,0x80},
/*311*/ {0x3a0f,0x38},
/*312*/ {0x3a10,0x30},
/*313*/ {0x3a1b,0x3a},
/*314*/ {0x3a1e,0x2e},
/*315*/ {0x3a11,0x60},
/*316*/ {0x3a1f,0x10},
/*317*/ {0x5688,0xa6},
/*318*/ {0x5689,0x6a},
/*319*/ {0x568a,0xea},
/*320*/ {0x568b,0xae},
/*321*/ {0x568c,0xa6},
/*322*/ {0x568d,0x6a},
/*323*/ {0x568e,0x62},
/*324*/ {0x568f,0x26},
/*325*/ {0x5583,0x40},
/*326*/ {0x5584,0x40},
/*327*/ {0x5580,0x02},
/*328*/ {0x5000,0xcf},
/*329*/ {0x5800,0x27},
/*330*/ {0x5801,0x19},
/*331*/ {0x5802,0x12},
/*332*/ {0x5803,0x0f},
/*333*/ {0x5804,0x10},
/*334*/ {0x5805,0x15},
/*335*/ {0x5806,0x1e},
/*336*/ {0x5807,0x2f},
/*337*/ {0x5808,0x15},
/*338*/ {0x5809,0x0d},
/*339*/ {0x580a,0x0a},
/*340*/ {0x580b,0x09},
/*341*/ {0x580c,0x0a},
/*342*/ {0x580d,0x0c},
/*343*/ {0x580e,0x12},
/*344*/ {0x580f,0x19},
/*345*/ {0x5810,0x0b},
/*346*/ {0x5811,0x07},
/*347*/ {0x5812,0x04},
/*348*/ {0x5813,0x03},
/*349*/ {0x5814,0x03},
/*350*/ {0x5815,0x06},
/*351*/ {0x5816,0x0a},
/*352*/ {0x5817,0x0f},
/*353*/ {0x5818,0x0a},
/*354*/ {0x5819,0x05},
/*355*/ {0x581a,0x01},
/*356*/ {0x581b,0x00},
/*357*/ {0x581c,0x00},
/*358*/ {0x581d,0x03},
/*359*/ {0x581e,0x08},
/*360*/ {0x581f,0x0c},
/*361*/ {0x5820,0x0a},
/*362*/ {0x5821,0x05},
/*363*/ {0x5822,0x01},
/*364*/ {0x5823,0x00},
/*365*/ {0x5824,0x00},
/*366*/ {0x5825,0x03},
/*367*/ {0x5826,0x08},
/*368*/ {0x5827,0x0c},
/*369*/ {0x5828,0x0e},
/*370*/ {0x5829,0x08},
/*371*/ {0x582a,0x06},
/*372*/ {0x582b,0x04},
/*373*/ {0x582c,0x05},
/*374*/ {0x582d,0x07},
/*375*/ {0x582e,0x0b},
/*376*/ {0x582f,0x12},
/*377*/ {0x5830,0x18},
/*378*/ {0x5831,0x10},
/*379*/ {0x5832,0x0c},
/*380*/ {0x5833,0x0a},
/*381*/ {0x5834,0x0b},
/*382*/ {0x5835,0x0e},
/*383*/ {0x5836,0x15},
/*384*/ {0x5837,0x19},
/*385*/ {0x5838,0x32},
/*386*/ {0x5839,0x1f},
/*387*/ {0x583a,0x18},
/*388*/ {0x583b,0x16},
/*389*/ {0x583c,0x17},
/*390*/ {0x583d,0x1e},
/*391*/ {0x583e,0x26},
/*392*/ {0x583f,0x53},
/*393*/ {0x5840,0x10},
/*394*/ {0x5841,0x0f},
/*395*/ {0x5842,0x0d},
/*396*/ {0x5843,0x0c},
/*397*/ {0x5844,0x0e},
/*398*/ {0x5845,0x09},
/*399*/ {0x5846,0x11},
/*400*/ {0x5847,0x10},
/*401*/ {0x5848,0x10},
/*402*/ {0x5849,0x10},
/*403*/ {0x584a,0x10},
/*404*/ {0x584b,0x0e},
/*405*/ {0x584c,0x10},
/*406*/ {0x584d,0x10},
/*407*/ {0x584e,0x11},
/*408*/ {0x584f,0x10},
/*409*/ {0x5850,0x0f},
/*410*/ {0x5851,0x0c},
/*411*/ {0x5852,0x0f},
/*412*/ {0x5853,0x10},
/*413*/ {0x5854,0x10},
/*414*/ {0x5855,0x0f},
/*415*/ {0x5856,0x0e},
/*416*/ {0x5857,0x0b},
/*417*/ {0x5858,0x10},
/*418*/ {0x5859,0x0d},
/*419*/ {0x585a,0x0d},
/*420*/ {0x585b,0x0c},
/*421*/ {0x585c,0x0c},
/*422*/ {0x585d,0x0c},
/*423*/ {0x585e,0x0b},
/*424*/ {0x585f,0x0c},
/*425*/ {0x5860,0x0c},
/*426*/ {0x5861,0x0c},
/*427*/ {0x5862,0x0d},
/*428*/ {0x5863,0x08},
/*429*/ {0x5864,0x11},
/*430*/ {0x5865,0x18},
/*431*/ {0x5866,0x18},
/*432*/ {0x5867,0x19},
/*433*/ {0x5868,0x17},
/*434*/ {0x5869,0x19},
/*435*/ {0x586a,0x16},
/*436*/ {0x586b,0x13},
/*437*/ {0x586c,0x13},
/*438*/ {0x586d,0x12},
/*439*/ {0x586e,0x13},
/*440*/ {0x586f,0x16},
/*441*/ {0x5870,0x14},
/*442*/ {0x5871,0x12},
/*443*/ {0x5872,0x10},
/*444*/ {0x5873,0x11},
/*445*/ {0x5874,0x11},
/*446*/ {0x5875,0x16},
/*447*/ {0x5876,0x14},
/*448*/ {0x5877,0x11},
/*449*/ {0x5878,0x10},
/*450*/ {0x5879,0x0f},
/*451*/ {0x587a,0x10},
/*452*/ {0x587b,0x14},
/*453*/ {0x587c,0x13},
/*454*/ {0x587d,0x12},
/*455*/ {0x587e,0x11},
/*456*/ {0x587f,0x11},
/*457*/ {0x5880,0x12},
/*458*/ {0x5881,0x15},
/*459*/ {0x5882,0x14},
/*460*/ {0x5883,0x15},
/*461*/ {0x5884,0x15},
/*462*/ {0x5885,0x15},
/*463*/ {0x5886,0x13},
/*464*/ {0x5887,0x17},
/*465*/ {0x3710,0x10},
/*466*/ {0x3632,0x51},
/*467*/ {0x3702,0x10},
/*468*/ {0x3703,0xb2},
/*469*/ {0x3704,0x18},
/*470*/ {0x370b,0x40},
/*471*/ {0x370d,0x03},
/*472*/ {0x3631,0x01},
/*473*/ {0x3632,0x52},
/*474*/ {0x3606,0x24},
/*475*/ {0x3620,0x96},
/*476*/ {0x5785,0x07},
/*477*/ {0x3a13,0x30},
/*478*/ {0x3600,0x52},
/*479*/ {0x3604,0x48},
/*480*/ {0x3606,0x1b},
/*481*/ {0x370d,0x0b},
/*482*/ {0x370f,0xc0},
/*483*/ {0x3709,0x01},
/*484*/ {0x3823,0x00},
/*485*/ {0x5007,0x00},
/*486*/ {0x5009,0x00},
/*487*/ {0x5011,0x00},
/*488*/ {0x5013,0x00},
/*489*/ {0x519e,0x00},
/*490*/ {0x5086,0x00},
/*491*/ {0x5087,0x00},
/*492*/ {0x5088,0x00},
/*493*/ {0x5089,0x00},
/*494*/ {0x302b,0x00},
/*495*/ {0x4800,0x24}, //changed 0x4 to 0x24 to gate clock
/*496*/ {0x4801,0x0f},
/*497*/ {0x3007,0x3b},
/*498*/ {0x300e,0x04},
/*499*/ {0x4803,0x50},
/*500*/ {0x3815,0x01},
/*501*/ {0x4713,0x02},
/*502*/ {0x4842,0x01},
/*503*/ {0x3033,0x43},
/*504*/ {0x3815,0x02},
/*505*/ {0x300f,0x0a},
/*506*/ {0x3003,0x03},
/*507*/ {0x3003,0x01},

// CIF
		{0x3800,0x1},
		{0x3801,0x50},
		{0x3802,0x0},
		{0x3803,0x8},
		{0x3804,0x4},
		{0x3805,0x96},
		{0x3806,0x3},
		{0x3807,0xc0},
		{0x3808,0x1},
		{0x3809,0x60},
		{0x380a,0x1},
/*507*/ {0x380b,0x20},
/*508*/ {0x380c,0xc},
/*509*/ {0x380d,0x80},
/*510*/ {0x380e,0x3},
/*511*/ {0x380f,0xe8},
/*512*/ {0x5001,0x7f},
/*513*/ {0x5680,0x0},
/*514*/ {0x5681,0x0},
/*515*/ {0x5682,0x4},
/*516*/ {0x5683,0x96},
/*517*/ {0x5684,0x0},
/*518*/ {0x5685,0x0},
/*519*/ {0x5686,0x3},
/*510*/ {0x5687,0xc0},

///* 2 */ {0x503d,0x80}, // test pattern
};

static const ov5642_reg_t ov5642_regs_mode_VGA[] =
{
/* 0 */ {0x3103,0x93},
/* 1 */ {0x3008,0x82},
/* 2 */ {0x3017,0x7f},
/* 3 */ {0x3018,0xfc},
/* 4 */ {0x3810,0xc2},
/* 5 */ {0x3615,0xf0},
/* 6 */ {0x1000,0x00},
/* 7 */ {0x3001,0x00},
/* 8 */ {0x3002,0x5c},
/* 9 */ {0x3003,0x00},
/* 10 */ {0x3004,0xff},
/* 11 */ {0x3005,0xff},
/* 12 */ {0x3006,0x43},
/* 13 */ {0x3007,0x37},
/* 14 */ {0x3011,0x08},
/* 15 */ {0x3010,0x10}, //0x10 lower clock by 7
/* 16 */ {0x460c,0x22},
/* 17 */ {0x3815,0x04},
/* 18 */ {0x370c,0xa0},
/* 19 */ {0x3602,0xfc},
/* 20 */ {0x3612,0xff},
/* 21 */ {0x3634,0xc0},
/* 22 */ {0x3613,0x00},
/* 23 */ {0x3605,0x7c},
/* 24 */ {0x3621,0x09},
/* 25 */ {0x3622,0x60},
/* 26 */ {0x3604,0x40},
/* 27 */ {0x3603,0xa7},
/* 28 */ {0x3603,0x27},
/* 29 */ {0x4000,0x21},
/* 30 */ {0x401d,0x22},
/* 31 */ {0x3600,0x54},
/* 32 */ {0x3605,0x04},
/* 33 */ {0x3606,0x3f},
/* 34 */ {0x3c01,0x80},
/* 35 */ {0x5000,0x4f},
/* 36 */ {0x5020,0x04},
/* 37 */ {0x5181,0x79},
/* 38 */ {0x5182,0x00},
/* 39 */ {0x5185,0x22},
/* 40 */ {0x5197,0x01},
/* 41 */ {0x5001,0xff},
/* 42 */ {0x5500,0x0a},
/* 43 */ {0x5504,0x00},
/* 44 */ {0x5505,0x7f},
/* 45 */ {0x5080,0x08},
/* 46 */ {0x300e,0x18},
/* 47 */ {0x4610,0x00},
/* 48 */ {0x471d,0x05},
/* 49 */ {0x4708,0x06},
/* 50 */ {0x3808,0x02},
/* 51 */ {0x3809,0x80},
/* 52 */ {0x380a,0x01},
/* 53 */ {0x380b,0xe0},
/* 54 */ {0x380e,0x07},
/* 55 */ {0x380f,0xd0},
/* 56 */ {0x501f,0x00},
/* 57 */ {0x5000,0x4f},
/* 58 */ {0x4300,0x32}, //changes from 0x30 to 0x32 for UYVY (CbCrY)
/* 59 */ {0x3503,0x07},
/* 60 */ {0x3501,0x73},
/* 61 */ {0x3502,0x80},
/* 62 */ {0x350b,0x00},
/* 63 */ {0x3503,0x07},
/* 64 */ {0x3824,0x11},
/* 65 */ {0x3501,0x1e},
/* 66 */ {0x3502,0x80},
/* 67 */ {0x350b,0x7f},
/* 68 */ {0x380c,0x0c},
/* 69 */ {0x380d,0x80},
/* 70 */ {0x380e,0x03},
/* 71 */ {0x380f,0xe8},
/* 72 */ {0x3a0d,0x04},
/* 73 */ {0x3a0e,0x03},
/* 74 */ {0x3818,0xc1},
/* 75 */ {0x3705,0xdb},
/* 76 */ {0x370a,0x81},
/* 77 */ {0x3801,0x80},
/* 78 */ {0x3621,0x87},
/* 79 */ {0x3801,0x50},
/* 80 */ {0x3803,0x08},
/* 81 */ {0x3827,0x08},
/* 82 */ {0x3810,0x40},
/* 83 */ {0x3804,0x05},
/* 84 */ {0x3805,0x00},
/* 85 */ {0x5682,0x05},
/* 86 */ {0x5683,0x00},
/* 87 */ {0x3806,0x03},
/* 88 */ {0x3807,0xc0},
/* 89 */ {0x5686,0x03},
/* 90 */ {0x5687,0xbc},
/* 91 */ {0x3a00,0x78},
/* 92 */ {0x3a1a,0x05},
/* 93 */ {0x3a13,0x30},
/* 94 */ {0x3a18,0x00},
/* 95 */ {0x3a19,0x7c},
/* 96 */ {0x3a08,0x12},
/* 97 */ {0x3a09,0xc0},
/* 98 */ {0x3a0a,0x0f},
/* 99 */ {0x3a0b,0xa0},
/* 100 */ {0x350c,0x07},
/* 101 */ {0x350d,0xd0},
/* 102 */ {0x3500,0x00},
/* 103 */ {0x3501,0x00},
/* 104 */ {0x3502,0x00},
/* 105 */ {0x350a,0x00},
/* 106 */ {0x350b,0x00},
/* 107 */ {0x3503,0x00},
/* 108 */ {0x528a,0x02},
/* 109 */ {0x528b,0x04},
/* 110 */ {0x528c,0x08},
/* 111 */ {0x528d,0x08},
/* 112 */ {0x528e,0x08},
/* 113 */ {0x528f,0x10},
/* 114 */ {0x5290,0x10},
/* 115 */ {0x5292,0x00},
/* 116 */ {0x5293,0x02},
/* 117 */ {0x5294,0x00},
/* 118 */ {0x5295,0x02},
/* 119 */ {0x5296,0x00},
/* 120 */ {0x5297,0x02},
/* 121 */ {0x5298,0x00},
/* 122 */ {0x5299,0x02},
/* 123 */ {0x529a,0x00},
/* 124 */ {0x529b,0x02},
/* 125 */ {0x529c,0x00},
/* 126 */ {0x529d,0x02},
/* 127 */ {0x529e,0x00},
/* 128 */ {0x529f,0x02},
/* 129 */ {0x3a0f,0x3c},
/* 130 */ {0x3a10,0x30},
/* 131 */ {0x3a1b,0x3c},
/* 132 */ {0x3a1e,0x30},
/* 133 */ {0x3a11,0x70},
/* 134 */ {0x3a1f,0x10},
/* 135 */ {0x3030,0x0b}, //was 0x2b bypass regulator
/* 136 */ {0x3a02,0x00},
/* 137 */ {0x3a03,0x7d},
/* 138 */ {0x3a04,0x00},
/*139*/ {0x3a14,0x00},
/*140*/ {0x3a15,0x7d},
/*141*/ {0x3a16,0x00},
/*142*/ {0x3a00,0x78},
/*143*/ {0x3a08,0x09},
/*144*/ {0x3a09,0x60},
/*145*/ {0x3a0a,0x07},
/*146*/ {0x3a0b,0xd0},
/*147*/ {0x3a0d,0x08},
/*148*/ {0x3a0e,0x06},
/*149*/ {0x5193,0x70},
/*150*/ {0x589b,0x04},
/*151*/ {0x589a,0xc5},
/*152*/ {0x401e,0x20},
/*153*/ {0x4001,0x42},
/*154*/ {0x401c,0x04},
/*155*/ {0x528a,0x01},
/*156*/ {0x528b,0x04},
/*157*/ {0x528c,0x08},
/*158*/ {0x528d,0x10},
/*159*/ {0x528e,0x20},
/*160*/ {0x528f,0x28},
/*161*/ {0x5290,0x30},
/*162*/ {0x5292,0x00},
/*163*/ {0x5293,0x01},
/*164*/ {0x5294,0x00},
/*165*/ {0x5295,0x04},
/*166*/ {0x5296,0x00},
/*167*/ {0x5297,0x08},
/*168*/ {0x5298,0x00},
/*169*/ {0x5299,0x10},
/*170*/ {0x529a,0x00},
/*171*/ {0x529b,0x20},
/*172*/ {0x529c,0x00},
/*173*/ {0x529d,0x28},
/*174*/ {0x529e,0x00},
/*175*/ {0x529f,0x30},
/*176*/ {0x5282,0x00},
/*177*/ {0x5300,0x00},
/*178*/ {0x5301,0x20},
/*179*/ {0x5302,0x00},
/*180*/ {0x5303,0x7c},
/*181*/ {0x530c,0x00},
/*182*/ {0x530d,0x0c},
/*183*/ {0x530e,0x20},
/*184*/ {0x530f,0x80},
/*185*/ {0x5310,0x20},
/*186*/ {0x5311,0x80},
/*187*/ {0x5308,0x20},
/*188*/ {0x5309,0x40},
/*189*/ {0x5304,0x00},
/*190*/ {0x5305,0x30},
/*191*/ {0x5306,0x00},
/*192*/ {0x5307,0x80},
/*193*/ {0x5314,0x08},
/*194*/ {0x5315,0x20},
/*195*/ {0x5319,0x30},
/*196*/ {0x5316,0x10},
/*197*/ {0x5317,0x00},
/*198*/ {0x5318,0x02},
/*199*/ {0x5380,0x01},
/*200*/ {0x5381,0x00},
/*201*/ {0x5382,0x00},
/*202*/ {0x5383,0x4e},
/*203*/ {0x5384,0x00},
/*204*/ {0x5385,0x0f},
/*205*/ {0x5386,0x00},
/*206*/ {0x5387,0x00},
/*207*/ {0x5388,0x01},
/*208*/ {0x5389,0x15},
/*209*/ {0x538a,0x00},
/*210*/ {0x538b,0x31},
/*211*/ {0x538c,0x00},
/*212*/ {0x538d,0x00},
/*213*/ {0x538e,0x00},
/*214*/ {0x538f,0x0f},
/*215*/ {0x5390,0x00},
/*216*/ {0x5391,0xab},
/*217*/ {0x5392,0x00},
/*218*/ {0x5393,0xa2},
/*219*/ {0x5394,0x08},
/*220*/ {0x5480,0x14},
/*221*/ {0x5481,0x21},
/*222*/ {0x5482,0x36},
/*223*/ {0x5483,0x57},
/*224*/ {0x5484,0x65},
/*225*/ {0x5485,0x71},
/*226*/ {0x5486,0x7d},
/*227*/ {0x5487,0x87},
/*228*/ {0x5488,0x91},
/*229*/ {0x5489,0x9a},
/*230*/ {0x548a,0xaa},
/*231*/ {0x548b,0xb8},
/*232*/ {0x548c,0xcd},
/*233*/ {0x548d,0xdd},
/*234*/ {0x548e,0xea},
/*235*/ {0x548f,0x1d},
/*236*/ {0x5490,0x05},
/*237*/ {0x5491,0x00},
/*238*/ {0x5492,0x04},
/*239*/ {0x5493,0x20},
/*240*/ {0x5494,0x03},
/*241*/ {0x5495,0x60},
/*242*/ {0x5496,0x02},
/*243*/ {0x5497,0xb8},
/*244*/ {0x5498,0x02},
/*245*/ {0x5499,0x86},
/*246*/ {0x549a,0x02},
/*247*/ {0x549b,0x5b},
/*248*/ {0x549c,0x02},
/*249*/ {0x549d,0x3b},
/*250*/ {0x549e,0x02},
/*251*/ {0x549f,0x1c},
/*252*/ {0x54a0,0x02},
/*253*/ {0x54a1,0x04},
/*254*/ {0x54a2,0x01},
/*255*/ {0x54a3,0xed},
/*256*/ {0x54a4,0x01},
/*257*/ {0x54a5,0xc5},
/*258*/ {0x54a6,0x01},
/*259*/ {0x54a7,0xa5},
/*260*/ {0x54a8,0x01},
/*261*/ {0x54a9,0x6c},
/*262*/ {0x54aa,0x01},
/*263*/ {0x54ab,0x41},
/*264*/ {0x54ac,0x01},
/*265*/ {0x54ad,0x20},
/*266*/ {0x54ae,0x00},
/*267*/ {0x54af,0x16},
/*268*/ {0x54b0,0x01},
/*269*/ {0x54b1,0x20},
/*270*/ {0x54b2,0x00},
/*271*/ {0x54b3,0x10},
/*272*/ {0x54b4,0x00},
/*273*/ {0x54b5,0xf0},
/*274*/ {0x54b6,0x00},
/*275*/ {0x54b7,0xdf},
/*276*/ {0x5402,0x3f},
/*277*/ {0x5403,0x00},
/*278*/ {0x3406,0x00},
/*279*/ {0x5180,0xff},
/*280*/ {0x5181,0x52},
/*281*/ {0x5182,0x11},
/*282*/ {0x5183,0x14},
/*283*/ {0x5184,0x25},
/*284*/ {0x5185,0x24},
/*285*/ {0x5186,0x06},
/*286*/ {0x5187,0x08},
/*287*/ {0x5188,0x08},
/*288*/ {0x5189,0x7c},
/*289*/ {0x518a,0x60},
/*290*/ {0x518b,0xb2},
/*291*/ {0x518c,0xb2},
/*292*/ {0x518d,0x44},
/*293*/ {0x518e,0x3d},
/*294*/ {0x518f,0x58},
/*295*/ {0x5190,0x46},
/*296*/ {0x5191,0xf8},
/*297*/ {0x5192,0x04},
/*298*/ {0x5193,0x70},
/*299*/ {0x5194,0xf0},
/*300*/ {0x5195,0xf0},
/*301*/ {0x5196,0x03},
/*302*/ {0x5197,0x01},
/*303*/ {0x5198,0x04},
/*304*/ {0x5199,0x12},
/*305*/ {0x519a,0x04},
/*306*/ {0x519b,0x00},
/*307*/ {0x519c,0x06},
/*308*/ {0x519d,0x82},
/*309*/ {0x519e,0x00}, //
/*310*/ {0x5025,0x80},
/*311*/ {0x3a0f,0x38},
/*312*/ {0x3a10,0x30},
/*313*/ {0x3a1b,0x3a},
/*314*/ {0x3a1e,0x2e},
/*315*/ {0x3a11,0x60},
/*316*/ {0x3a1f,0x10},
/*317*/ {0x5688,0xa6},
/*318*/ {0x5689,0x6a},
/*319*/ {0x568a,0xea},
/*320*/ {0x568b,0xae},
/*321*/ {0x568c,0xa6},
/*322*/ {0x568d,0x6a},
/*323*/ {0x568e,0x62},
/*324*/ {0x568f,0x26},
/*325*/ {0x5583,0x40},
/*326*/ {0x5584,0x40},
/*327*/ {0x5580,0x02},
/*328*/ {0x5000,0xcf},
/*329*/ {0x5800,0x27},
/*330*/ {0x5801,0x19},
/*331*/ {0x5802,0x12},
/*332*/ {0x5803,0x0f},
/*333*/ {0x5804,0x10},
/*334*/ {0x5805,0x15},
/*335*/ {0x5806,0x1e},
/*336*/ {0x5807,0x2f},
/*337*/ {0x5808,0x15},
/*338*/ {0x5809,0x0d},
/*339*/ {0x580a,0x0a},
/*340*/ {0x580b,0x09},
/*341*/ {0x580c,0x0a},
/*342*/ {0x580d,0x0c},
/*343*/ {0x580e,0x12},
/*344*/ {0x580f,0x19},
/*345*/ {0x5810,0x0b},
/*346*/ {0x5811,0x07},
/*347*/ {0x5812,0x04},
/*348*/ {0x5813,0x03},
/*349*/ {0x5814,0x03},
/*350*/ {0x5815,0x06},
/*351*/ {0x5816,0x0a},
/*352*/ {0x5817,0x0f},
/*353*/ {0x5818,0x0a},
/*354*/ {0x5819,0x05},
/*355*/ {0x581a,0x01},
/*356*/ {0x581b,0x00},
/*357*/ {0x581c,0x00},
/*358*/ {0x581d,0x03},
/*359*/ {0x581e,0x08},
/*360*/ {0x581f,0x0c},
/*361*/ {0x5820,0x0a},
/*362*/ {0x5821,0x05},
/*363*/ {0x5822,0x01},
/*364*/ {0x5823,0x00},
/*365*/ {0x5824,0x00},
/*366*/ {0x5825,0x03},
/*367*/ {0x5826,0x08},
/*368*/ {0x5827,0x0c},
/*369*/ {0x5828,0x0e},
/*370*/ {0x5829,0x08},
/*371*/ {0x582a,0x06},
/*372*/ {0x582b,0x04},
/*373*/ {0x582c,0x05},
/*374*/ {0x582d,0x07},
/*375*/ {0x582e,0x0b},
/*376*/ {0x582f,0x12},
/*377*/ {0x5830,0x18},
/*378*/ {0x5831,0x10},
/*379*/ {0x5832,0x0c},
/*380*/ {0x5833,0x0a},
/*381*/ {0x5834,0x0b},
/*382*/ {0x5835,0x0e},
/*383*/ {0x5836,0x15},
/*384*/ {0x5837,0x19},
/*385*/ {0x5838,0x32},
/*386*/ {0x5839,0x1f},
/*387*/ {0x583a,0x18},
/*388*/ {0x583b,0x16},
/*389*/ {0x583c,0x17},
/*390*/ {0x583d,0x1e},
/*391*/ {0x583e,0x26},
/*392*/ {0x583f,0x53},
/*393*/ {0x5840,0x10},
/*394*/ {0x5841,0x0f},
/*395*/ {0x5842,0x0d},
/*396*/ {0x5843,0x0c},
/*397*/ {0x5844,0x0e},
/*398*/ {0x5845,0x09},
/*399*/ {0x5846,0x11},
/*400*/ {0x5847,0x10},
/*401*/ {0x5848,0x10},
/*402*/ {0x5849,0x10},
/*403*/ {0x584a,0x10},
/*404*/ {0x584b,0x0e},
/*405*/ {0x584c,0x10},
/*406*/ {0x584d,0x10},
/*407*/ {0x584e,0x11},
/*408*/ {0x584f,0x10},
/*409*/ {0x5850,0x0f},
/*410*/ {0x5851,0x0c},
/*411*/ {0x5852,0x0f},
/*412*/ {0x5853,0x10},
/*413*/ {0x5854,0x10},
/*414*/ {0x5855,0x0f},
/*415*/ {0x5856,0x0e},
/*416*/ {0x5857,0x0b},
/*417*/ {0x5858,0x10},
/*418*/ {0x5859,0x0d},
/*419*/ {0x585a,0x0d},
/*420*/ {0x585b,0x0c},
/*421*/ {0x585c,0x0c},
/*422*/ {0x585d,0x0c},
/*423*/ {0x585e,0x0b},
/*424*/ {0x585f,0x0c},
/*425*/ {0x5860,0x0c},
/*426*/ {0x5861,0x0c},
/*427*/ {0x5862,0x0d},
/*428*/ {0x5863,0x08},
/*429*/ {0x5864,0x11},
/*430*/ {0x5865,0x18},
/*431*/ {0x5866,0x18},
/*432*/ {0x5867,0x19},
/*433*/ {0x5868,0x17},
/*434*/ {0x5869,0x19},
/*435*/ {0x586a,0x16},
/*436*/ {0x586b,0x13},
/*437*/ {0x586c,0x13},
/*438*/ {0x586d,0x12},
/*439*/ {0x586e,0x13},
/*440*/ {0x586f,0x16},
/*441*/ {0x5870,0x14},
/*442*/ {0x5871,0x12},
/*443*/ {0x5872,0x10},
/*444*/ {0x5873,0x11},
/*445*/ {0x5874,0x11},
/*446*/ {0x5875,0x16},
/*447*/ {0x5876,0x14},
/*448*/ {0x5877,0x11},
/*449*/ {0x5878,0x10},
/*450*/ {0x5879,0x0f},
/*451*/ {0x587a,0x10},
/*452*/ {0x587b,0x14},
/*453*/ {0x587c,0x13},
/*454*/ {0x587d,0x12},
/*455*/ {0x587e,0x11},
/*456*/ {0x587f,0x11},
/*457*/ {0x5880,0x12},
/*458*/ {0x5881,0x15},
/*459*/ {0x5882,0x14},
/*460*/ {0x5883,0x15},
/*461*/ {0x5884,0x15},
/*462*/ {0x5885,0x15},
/*463*/ {0x5886,0x13},
/*464*/ {0x5887,0x17},
/*465*/ {0x3710,0x10},
/*466*/ {0x3632,0x51},
/*467*/ {0x3702,0x10},
/*468*/ {0x3703,0xb2},
/*469*/ {0x3704,0x18},
/*470*/ {0x370b,0x40},
/*471*/ {0x370d,0x03},
/*472*/ {0x3631,0x01},
/*473*/ {0x3632,0x52},
/*474*/ {0x3606,0x24},
/*475*/ {0x3620,0x96},
/*476*/ {0x5785,0x07},
/*477*/ {0x3a13,0x30},
/*478*/ {0x3600,0x52},
/*479*/ {0x3604,0x48},
/*480*/ {0x3606,0x1b},
/*481*/ {0x370d,0x0b},
/*482*/ {0x370f,0xc0},
/*483*/ {0x3709,0x01},
/*484*/ {0x3823,0x00},
/*485*/ {0x5007,0x00},
/*486*/ {0x5009,0x00},
/*487*/ {0x5011,0x00},
/*488*/ {0x5013,0x00},
/*489*/ {0x519e,0x00},
/*490*/ {0x5086,0x00},
/*491*/ {0x5087,0x00},
/*492*/ {0x5088,0x00},
/*493*/ {0x5089,0x00},
/*494*/ {0x302b,0x00},
/*495*/ {0x4800,0x24}, //changed 0x4 to 0x24 to gate clock
/*496*/ {0x4801,0x0f},
/*497*/ {0x3007,0x3b},
/*498*/ {0x300e,0x04},
/*499*/ {0x4803,0x50},
/*500*/ {0x3815,0x01},
/*501*/ {0x4713,0x02},
/*502*/ {0x4842,0x01},
/*503*/ {0x3033,0x43},
/*504*/ {0x3815,0x02},
/*505*/ {0x300f,0x0a},
/*506*/ {0x3003,0x03},
/*507*/ {0x3003,0x01},
///* 2 */ {0x503d,0x80}, // test pattern
};

/**********************************
 * sensor configuration
 **********************************/

/* OV5642 modes */
const static ov5642_mode_t ov5642_modes[] =
{
    /* CIF */
	{
		.width    = 352,
		.height   = 288,
		.name     = "OV5642_RESOLUTION_CIF",
		.reg_list = ov5642_regs_mode_CIF,
		.num_regs = array_size( ov5642_regs_mode_CIF ),
	},

    /* VGA */
	{
		.width    = 640,
		.height   = 480,
		.name     = "OV5642_RESOLUTION_VGA",
		.reg_list = ov5642_regs_mode_VGA,
		.num_regs = array_size( ov5642_regs_mode_VGA ),
	},

#if 0
    /* 1.3MP */
	{
		.width    = 1280,
		.height   = 960,
		.name     = "OV5642_RESOLUTION_1.3MP",
		.reg_list = ov5642_regs_mode_1_3MP,
		.num_regs = array_size( ov5642_regs_mode_1_3MP )
	},

    /* 5MP */
	{
		.width    = 2592,
		.height   = 1944,
		.name     = "OV5642_RESOLUTION_5MP",
		.reg_list = ov5642_regs_mode_5MP,
		.num_regs = array_size( ov5642_regs_mode_5MP )
	},
#endif
};

#define OV5642_NUM_MODES array_size( ov5642_modes )

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

const struct v4l2_fract ov5642_frameintervals[] = {
	{ .numerator = 1, .denominator = 3 },
	{ .numerator = 2, .denominator = 15 },
	{ .numerator = 1, .denominator = 11 },
	{ .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 20 },
	{ .numerator = 1, .denominator = 25 },
	{ .numerator = 1, .denominator = 30 },
};

#ifdef CONFIG_DMW96_CIU_DEBUG
static const char* frame_rate_tostring(unsigned int frame_rate)
{
	switch (frame_rate)
	{
		case	OV5642_3_FPS:
			return "OV5642_3_FPS";
		case	OV5642_7_5_FPS:
			return "OV5642_7_5_FPS";
		case	OV5642_11_FPS:
			return "OV5642_11_FPS";
		case	OV5642_15_FPS:
			return "OV5642_15_FPS";
		case	OV5642_20_FPS:
			return "OV5642_20_FPS";
		case	OV5642_25_FPS:
			return "OV5642_25_FPS";
		case	OV5642_30_FPS:
			return "OV5642_30_FPS";
		default:
				return "INVALID";
	}
}
#endif

/* List of image formats supported by OV5642 sensor */
const static struct v4l2_fmtdesc ov5642_formats[] = {
#if OV5642_RAW_MODE
       {
               .description    = "RAW10",
               .pixelformat    = V4L2_PIX_FMT_SGRBG10,
       },
#else
	   {
               /* Note:  V4L2 defines FMT_NV16 as:
                *	Two planes -- one Y, one Cr + Cb interleaved
                *   y0y1y2y3 u0v0u1v1
                */
		       .description    = "Y/CbCr, 4:2:2",
               .pixelformat    = V4L2_PIX_FMT_NV16,
	   },

	   // TODO not supported in MIPI???
#if 0
	   {
               /* Note:  V4L2 defines FMT_NV61 as:
                *	Two planes -- one Y, one Cr + Cb interleaved
                *   y0y1y2y3 v0u0v1u1
                */
		       .description    = "Y/CrCb, 4:2:2",
               .pixelformat    = V4L2_PIX_FMT_NV61,
	   },

	   {
               /* Note:  V4L2 defines FMT_NV12 as:
                *	Two planes -- one Y, one Cr + Cb interleaved
                *   y0y1y2y3 u0v0
                */
		       .description    = "Y/CbCr, 4:2:0",
               .pixelformat    = V4L2_PIX_FMT_NV12,
	   },
	   {
               /* Note:  V4L2 defines FMT_NV12 as:
                *	Two planes -- one Y, one Cr + Cb interleaved
                *   y0y1y2y3 v0u0
                */
		       .description    = "Y/CrCb, 4:2:0",
               .pixelformat    = V4L2_PIX_FMT_NV21,
	   },
       {
               /* Note:  V4L2 defines RGB565 as:
                *
                *      Byte 0                    Byte 1
                *      g2 g1 g0 r4 r3 r2 r1 r0   b4 b3 b2 b1 b0 g5 g4 g3
                *
                * We interpret RGB565 as:
                *
                *      Byte 0                    Byte 1
                *      g2 g1 g0 b4 b3 b2 b1 b0   r4 r3 r2 r1 r0 g5 g4 g3
                */
               .description    = "RGB565, le",
               .pixelformat    = V4L2_PIX_FMT_RGB565,
       },
       {
               /* Note:  V4L2 defines RGB565X as:
                *
                *      Byte 0                    Byte 1
                *      b4 b3 b2 b1 b0 g5 g4 g3   g2 g1 g0 r4 r3 r2 r1 r0
                *
                * We interpret RGB565X as:
                *
                *      Byte 0                    Byte 1
                *      r4 r3 r2 r1 r0 g5 g4 g3   g2 g1 g0 b4 b3 b2 b1 b0
                */
               .description    = "RGB565, be",
               .pixelformat    = V4L2_PIX_FMT_RGB565X,
       },
       {
               .description    = "YUYV (YUV 4:2:2), packed",
               .pixelformat    = V4L2_PIX_FMT_YUYV,
       },
       {
               .description    = "UYVY, packed",
               .pixelformat    = V4L2_PIX_FMT_UYVY,
       },
       {
               /* Note:  V4L2 defines RGB555 as:
                *
                *      Byte 0                    Byte 1
                *      g2 g1 g0 r4 r3 r2 r1 r0   x  b4 b3 b2 b1 b0 g4 g3
                *
                * We interpret RGB555 as:
                *
                *      Byte 0                    Byte 1
                *      g2 g1 g0 b4 b3 b2 b1 b0   x  r4 r3 r2 r1 r0 g4 g3
                */
               .description    = "RGB555, le",
               .pixelformat    = V4L2_PIX_FMT_RGB555,
       },
       {
               /* Note:  V4L2 defines RGB555X as:
                *
                *      Byte 0                    Byte 1
                *      x  b4 b3 b2 b1 b0 g4 g3   g2 g1 g0 r4 r3 r2 r1 r0
                *
                * We interpret RGB555X as:
                *
                *      Byte 0                    Byte 1
                *      x  r4 r3 r2 r1 r0 g4 g3   g2 g1 g0 b4 b3 b2 b1 b0
                */
               .description    = "RGB555, be",
               .pixelformat    = V4L2_PIX_FMT_RGB555X,
       },
#endif
#endif
};

#define NUM_CAPTURE_FORMATS array_size( ov5642_formats )
#define NUM_TIMEFRAME_VALS  array_size( ov5642_frameintervals )


const static ov5642_reg_t ov5642_common[200] =
{
	{OV5642_REG_TERM, OV5642_VAL_TERM},
};

const static ov5642_reg_t ov5642_standby_on[] =
{

	{OV5642_REG_TERM , OV5642_VAL_TERM},
};

const static ov5642_reg_t ov5642_standby_off[] =
{

	{OV5642_REG_TERM, OV5642_VAL_TERM},
};

/**
 * struct ov5642_sensor - main structure for storage of sensor information
 * @cam_port: camera port to which we're connected
 * @v4l2_int_device: V4L2 device structure structure
 * @pix: V4L2 pixel format information structure
 * @timeperframe: time per frame expressed as V4L fraction
 * @isize: base image size
 * @ver: ov5642 chip version
 * @width: configured width
 * @height: configuredheight
 * @vsize: vertical size for the image
 * @hsize: horizontal size for the image
 * @crop_rect: crop rectangle specifying the left,top and width and height
 */
struct ov5642_sensor
{
       struct dmw_camera_port_s * cam_port;
       struct v4l2_int_device *	  v4l2_int_device;
       struct v4l2_pix_format 	  pix;
       struct v4l2_fract 		  timeperframe;
       const ov5642_mode_t * 	  mode;
       int 						  ver;
       int 						  fps;
       unsigned long 			  vsize;
       unsigned long 			  hsize;
       struct v4l2_rect 		  crop_rect;
	   unsigned int 			  vflip;
	   unsigned int 			  hflip;
       int 						  state;
};

static struct ov5642_sensor ov5642;
static unsigned long xclk_current = OV5642_XCLK_MIN;

/* Brightness Settings - 7 levels */
const static ov5642_reg_t brightness[7][5] =
{
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
};

/* Contrast Settings - 7 levels */
const static ov5642_reg_t contrast[7][5] =
{
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
};

/* Color Settings - 3 colors */
const static ov5642_reg_t colors[3][5] =
{
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
};

/* Average Based Algorithm - Based on target Luminance */
const static ov5642_reg_t exposure_avg[11][5] =
{
       /* -1.7EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* -1.3EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* -1.0EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* -0.7EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* -0.3EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* default */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* 0.3EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* 0.7EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* 1.0EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* 1.3EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* 1.7EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
};

/* Histogram Based Algorithm - Based on histogram and probability */
const static ov5642_reg_t exposure_hist[11][5] =
{
       /* -1.7EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* -1.3EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* -1.0EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* -0.7EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* -0.3EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* default */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* 0.3EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* 0.7EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* 1.0EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* 1.3EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
       /* 1.7EV */
       {
               {OV5642_REG_TERM, OV5642_VAL_TERM}
       },
};


/*
 * struct vcontrol - Video controls
 * @v4l2_queryctrl: V4L2 VIDIOC_QUERYCTRL ioctl structure
 * @current_value: current value of this control
 */
static struct vcontrol
{
       struct v4l2_queryctrl qc;
       int current_value;
} video_control[] =
{
       {
               {
               .id = V4L2_CID_BRIGHTNESS,
               .type = V4L2_CTRL_TYPE_INTEGER,
               .name = "Brightness",
               .minimum = OV5642_MIN_BRIGHT,
               .maximum = OV5642_MAX_BRIGHT,
               .step = OV5642_BRIGHT_STEP,
               .default_value = OV5642_DEF_BRIGHT,
               },
       .current_value = OV5642_DEF_BRIGHT,
       },
       {
               {
               .id = V4L2_CID_CONTRAST,
               .type = V4L2_CTRL_TYPE_INTEGER,
               .name = "Contrast",
               .minimum = OV5642_MIN_CONTRAST,
               .maximum = OV5642_MAX_CONTRAST,
               .step = OV5642_CONTRAST_STEP,
               .default_value = OV5642_DEF_CONTRAST,
               },
       .current_value = OV5642_DEF_CONTRAST,
       },
       {
               {
               .id = V4L2_CID_PRIVATE_BASE,
               .type = V4L2_CTRL_TYPE_INTEGER,
               .name = "Color Effects",
               .minimum = OV5642_MIN_COLOR,
               .maximum = OV5642_MAX_COLOR,
               .step = OV5642_COLOR_STEP,
               .default_value = OV5642_DEF_COLOR,
               },
       .current_value = OV5642_DEF_COLOR,
       },
	   {
               {
               .id = V4L2_CID_VFLIP,
               .type = V4L2_CTRL_TYPE_BOOLEAN,
               .name = "Vertical Flip",
               .default_value = OV5642_DEF_FLIP,
               },
       .current_value = OV5642_DEF_FLIP,
       },
	   {
               {
               .id = V4L2_CID_HFLIP,
               .type = V4L2_CTRL_TYPE_BOOLEAN,
               .name = "Horizontal Flip (Mirror)",
               .default_value = OV5642_DEF_FLIP,
               },
       .current_value = OV5642_DEF_FLIP,
       }
};

/* check if a resolution is supported by the sensor */
static int check_if_res_supported( unsigned long width, unsigned long height )
{
	if ( (width > ov5642_modes[OV5642_NUM_MODES - 1].width) || (height > ov5642_modes[OV5642_NUM_MODES - 1].height) )
	{
		return -EINVAL;
	}

	return 0;
}

/*
 * find_vctrl - Finds the requested ID in the video control structure array
 * @id: ID of control to search the video control array.
 *
 * Returns the index of the requested ID from the control structure array
 */
static int find_vctrl( int id )
{
	int i = 0;

	if ( id < V4L2_CID_BASE )
		return -EDOM;

	for ( i = (ARRAY_SIZE( video_control ) - 1); i >= 0; i-- )
		if ( video_control[i].qc.id == id )
			break;
	if ( i < 0 )
		i = -EINVAL;
	return i;
}

/*
 * Read a value from a register in ov5642 sensor device.
 * The value is returned in 'val'.
 * Returns zero if successful, or non-zero otherwise.
 */
static int ov5642_read_reg( struct i2c_client * client, u16 data_length, u16 reg, unsigned long * val )
{
	int err = 0;
	struct i2c_msg msg[2];
	unsigned char data[4];

	if ( !client || !client->adapter )
	{
		PDEBUG("Invalid input\n");
		return -ENODEV;
	}

	msg[0].addr = client->addr;
	msg[0].flags = I2C_M_WR;
	msg[0].len = 2;
	msg[0].buf = data;

	msg[1].addr = client->addr;
	msg[1].flags = I2C_M_RD;
	msg[1].len = data_length;
	msg[1].buf = data;

	/* High byte goes out first */
	data[0] = (u8) (reg >> 8);
	data[1] = (u8) (reg & 0xff);

	err = i2c_transfer( client->adapter, msg, 2 );
	if ( err >= 0 )
	{
		*val = 0;
		/* High byte comes first */
		if ( data_length == 1 )
			*val = data[0];
		else if ( data_length == 2 )
			*val = data[1] + (data[0] << 8);
		else
			*val = data[3] + (data[2] << 8) + (data[1] << 16) + (data[0] << 24);

		return 0;
	}
	PDEBUG( "read from offset 0x%x error %d\n", reg, err );
	return err;
}

/* Write a value to a register in ov5642 sensor device.
 * @client: i2c driver client structure.
 * @reg: Address of the register to read value from.
 * @val: Value to be written to a specific register.
 * Returns zero if successful, or non-zero otherwise.
 */
static int ov5642_write_reg( struct i2c_client * client, u16 reg, u8 val )
{
	int err = 0;
	struct i2c_msg msg[1];
	unsigned char data[3];
	int retries = 0;

	if ( !client || !client->adapter )
	{
		PDEBUG("Invalid input\n");
		return -ENODEV;
	}
	//	PDEBUG("__78 %x %x\n",reg,val);
	retry: msg->addr = client->addr;
	msg->flags = I2C_M_WR;
	msg->len = 3;
	msg->buf = data;

	/* high byte goes out first */
	data[0] = (u8) (reg >> 8);
	data[1] = (u8) (reg & 0xff);
	data[2] = val;

	err = i2c_transfer( client->adapter, msg, 1 );
	udelay(50);

	if ( err >= 0 )
		return 0;

	if ( retries <= 5 )
	{
		dev_dbg(&client->dev, "Retrying I2C... %d", retries);
		retries++;
		set_current_state( TASK_UNINTERRUPTIBLE );
		schedule_timeout( msecs_to_jiffies( 20 ) );
		goto retry;
	}

	return err;
}

/*
 * Initialize a list of ov5642 registers.
 * The list of registers is terminated by the pair of values
 * {OV5642_REG_TERM, OV5642_VAL_TERM}.
 * @client: i2c driver client structure.
 * @reglist[]: List of address of the registers to write data.
 * Returns zero if successful, or non-zero otherwise.
 */
static int ov5642_write_regs( const ov5642_reg_t * reglist )
{
	int err = 0;
	const ov5642_reg_t *next;
	struct i2c_client * client;

	/* get i2c */
	client = dmw_camera_get_i2c( ov5642.cam_port,
								 &ov5642_sensor_desc );

	if ( !client )
	{
		return -EIO;
	}

	if ( !reglist )
	{
		dmw_camera_put_i2c( ov5642.cam_port );
		PDEBUG("Invalid input\n");
		return -1;
	}

	next = reglist;

	while ( next && !((next->reg == OV5642_REG_TERM) && (next->val == OV5642_VAL_TERM)) )
	{
		err = ov5642_write_reg( client, next->reg, next->val );
		udelay(100);
		if ( err )
		{
			dmw_camera_put_i2c( ov5642.cam_port );
			return err;
		}

		next++;
	}

	dmw_camera_put_i2c( ov5642.cam_port );
	return 0;
}

/* initialize sensor */
static int ov5642_init_sensor( const ov5642_mode_t * mode )
{
	s32 i = 0;
	int retval = 0;
	struct i2c_client * c;

	/* get i2c */
	c = dmw_camera_get_i2c( ov5642.cam_port,
				 	 	 	&ov5642_sensor_desc );

	if ( !c )
	{
		return -EIO;
	}

	if ( !mode )
	{
		dmw_camera_put_i2c( ov5642.cam_port );
		pr_err( "Wrong ov5642 mode\n" );
		return -EINVAL;
	}

	PDEBUG("mode = %s\n", mode->name);

	for ( i = 0; i < mode->num_regs; i++ )
	{
		retval = ov5642_write_reg( c, mode->reg_list[i].reg, mode->reg_list[i].val );

		if ( retval < 0 )
		{
			dmw_camera_put_i2c( ov5642.cam_port );
			return retval;
		}
	}

	dmw_camera_put_i2c( ov5642.cam_port );
	return retval;
}

static void ov5642_set_flip( void )
{
	PDEBUG("Hflip is %s  Vflip is %s\n", ((ov5642.hflip == 1) ? "On" : "Off") , ((ov5642.vflip == 1) ? "On" : "Off") );
	PDEBUG("%s\n",__func__);
#if 0
	ov5642_read_reg(client,1, 0x12, &regval);

	if (ov5642.hflip)
	ov5642_write_reg(client, 0x12, regval | (1<<5));
	else
	ov5642_write_reg(client, 0x12, regval & ~(1<<5));

	if (ov5642.vflip)
	ov5642_write_reg(client, 0x12, regval | (1<<4));
	else
	ov5642_write_reg(client, 0x12, regval & ~(1<<4));
#endif
}

static int ov5642_set_v_flip( unsigned int val )
{
	PDEBUG("%s\n",__func__);
	ov5642.vflip = ((val > 0) ? 1 : 0);

	ov5642_set_flip();

	return 0;
}

static int ov5642_set_h_flip( unsigned int val )
{
	PDEBUG("%s\n",__func__);
	ov5642.hflip = ((val > 0) ? 1 : 0);

	ov5642_set_flip();

	return 0;
}

/* Find the best match for a requested image capture size.  The best match
 * is chosen as the nearest match that has the same number or fewer pixels
 * as the requested size, or the smallest image size if the requested size
 * has fewer pixels than the smallest image.
 */
static const ov5642_mode_t * ov5642_find_mode( unsigned int width, unsigned int height )
{
	int i;
	const ov5642_mode_t * mode;

	for ( i = 0; i < OV5642_NUM_MODES; i++ )
	{
		mode = &(ov5642_modes[i]);

		/* if found a match */
		if ( (mode->height == height) && (mode->width == width) )
		{
			return mode;
		}
	}

	/* no match */
	return NULL;
}

static int set_frame_rate( struct v4l2_int_device *s, unsigned long xclk )
{
	struct ov5642_sensor *sensor;
	int res = 0;

	if ( !s || !s->priv )
		return -1;

	sensor = s->priv;
	res = dmw_camera_port_clock_ctl( sensor->cam_port,
									 xclk );
	if ( !res )
	{
		xclk_current = xclk;
	}
	return res;
}

// TODO
static int switch_fps( struct v4l2_fract *a, struct v4l2_int_device *s, enum ov5642_frameintervals_type* fps )
{
	unsigned int i = 0;
	unsigned int val;
	if ( !s || !a )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	PDEBUG("Try to set FPS to denominator=%d numerator=%d \n",a->denominator ,a->numerator );

	for ( i = 0; i < NUM_TIMEFRAME_VALS; i++ )
	{

		PDEBUG("Check FPS to denominator=%d numerator=%d \n", ov5642_frameintervals[i].denominator , ov5642_frameintervals[i].numerator);

		if ( (a->denominator == ov5642_frameintervals[i].denominator) && (a->numerator == ov5642_frameintervals[i].numerator) )
		{
			switch ( i )
			{
			case OV5642_3_FPS:
				*fps = OV5642_3_FPS;
				PDEBUG("setting 3 FPS\n");
				break;
			case OV5642_7_5_FPS:
				*fps = OV5642_7_5_FPS;
				PDEBUG("setting 7.5 FPS\n");
				break;
			case OV5642_11_FPS:
				*fps = OV5642_11_FPS;
				PDEBUG("setting 11 FPS\n");
				break;
			case OV5642_15_FPS:
				*fps = OV5642_15_FPS;
				PDEBUG("setting 15 FPS\n");
				break;
			case OV5642_20_FPS:
				*fps = OV5642_20_FPS;
				PDEBUG("setting 20 FPS\n");
				break;
			case OV5642_25_FPS:
				*fps = OV5642_25_FPS;
				PDEBUG("setting 25 FPS\n");
				break;
			case OV5642_30_FPS:
				*fps = OV5642_30_FPS;
				PDEBUG("setting 30 FPS\n");
				break;
			default:
				PDEBUG("Non existed set to 15 FPS as default\n");
				*fps = OV5642_15_FPS;
			}
			break;
		}
	}

	if ( i == NUM_TIMEFRAME_VALS )
	{
		PDEBUG("Invalid frame interval\n");
		return -1;
	}

	val = ((OV5642_XCLK_MAX * ov5642_frameintervals[*fps].denominator) / ov5642_frameintervals[*fps].numerator) / 30;

	PDEBUG("frame_rate=%s denominator=%d numerator=%d OV5642_XCLK_MAX=%d val=%d\n",
			frame_rate_tostring(*fps), ov5642_frameintervals[*fps].denominator , ov5642_frameintervals[*fps].numerator,
			OV5642_XCLK_MAX, val);

	set_frame_rate( s, val );

	return 0;
}

static int ov5642_configure( struct v4l2_int_device *s )
{
	struct ov5642_sensor *sensor = NULL;
	struct v4l2_pix_format *pix = NULL;
	enum ov5642_frameintervals_type frame_rate = OV5642_15_FPS;
	int err = 0;

	if ( s && s->priv )
	{
		sensor = s->priv;

		pix = &sensor->pix;
	}

	if ( !sensor || !pix  )
	{
		PDEBUG("Invalid input\n");
		return -EINVAL;
	}

	/* find a matching sensor mode */
	sensor->mode = ov5642_find_mode( pix->width, pix->height );

	if ( !sensor->mode )
		return err;

	ov5642_init_sensor( sensor->mode );

	switch_fps( &sensor->timeperframe, s, &frame_rate );

	//ov5642_set_flip(client);

	sensor->crop_rect.left = 0;
	sensor->crop_rect.width = pix->width;
	sensor->crop_rect.top = 0;
	sensor->crop_rect.height = pix->height;

	return 0;
}

/* Detect if an ov5642 is present, returns a negative error number if no
 * device is detected, or pidl as version number if a device is detected.
 */
static int ov5642_detect( void )
{
	unsigned long pidh = 0, pidl = 0;
	struct i2c_client *client;

	PDEBUG("%s\n",__func__);

	client = dmw_camera_get_i2c( ov5642.cam_port,
				 	 	 	 	 &ov5642_sensor_desc );

	if ( !client )
	{
		PDEBUG("Invalid input\n");
		return -ENODEV;
	}

	if ( ov5642_read_reg( client, 1, OV5642_PIDH, &pidh ) )
	{
		dmw_camera_put_i2c( ov5642.cam_port );
		return -ENODEV;
	}

	if ( ov5642_read_reg( client, 1, OV5642_PIDL, &pidl ) )
	{
		dmw_camera_put_i2c( ov5642.cam_port );
		return -ENODEV;
	}

	dmw_camera_put_i2c( ov5642.cam_port );

	if ( (pidh == OV5642_PIDH_MAGIC) && (pidl == OV5642_PIDL_MAGIC) )
	{
		PDEBUG( "Detected\n" );
		return 0;
	}

	return -ENODEV;
}

/* To get the cropping capabilities of ov5642 sensor
 * Returns zero if successful, or non-zero otherwise.
 */
static int ioctl_cropcap( struct v4l2_int_device *s, struct v4l2_cropcap *cropcap )
{
	return -EINVAL;
}

/* To get the current crop window for of ov5642 sensor
 * Returns zero if successful, or non-zero otherwise.
 */
static int ioctl_g_crop( struct v4l2_int_device *s, struct v4l2_crop *crop )
{
	struct ov5642_sensor *sensor;

	if ( !s || !crop )
	{
		PDEBUG("Invalid input\n");
		return -EINVAL;
	}

	sensor = s->priv;

	crop->c = sensor->crop_rect;
	return 0;
}

/* To set the crop window for of ov5642 sensor
 * Returns zero if successful, or non-zero otherwise.
 */
static int ioctl_s_crop( struct v4l2_int_device *s, struct v4l2_crop *crop )
{
	return -EINVAL;
}

/*
 * ioctl_queryctrl - V4L2 sensor interface handler for VIDIOC_QUERYCTRL ioctl
 * @s: pointer to standard V4L2 device structure
 * @qc: standard V4L2 VIDIOC_QUERYCTRL ioctl structure
 *
 * If the requested control is supported, returns the control information
 * from the video_control[] array.  Otherwise, returns -EINVAL if the
 * control is not supported.
 */
static int ioctl_queryctrl( struct v4l2_int_device *s, struct v4l2_queryctrl *qc )
{
	int i;

	if ( !s || !qc )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	i = find_vctrl( qc->id );
	if ( i == -EINVAL )
		qc->flags = V4L2_CTRL_FLAG_DISABLED;

	if ( i < 0 )
		return -EINVAL;

	*qc = video_control[i].qc;
	return 0;
}

/*
 * ioctl_g_ctrl - V4L2 sensor interface handler for VIDIOC_G_CTRL ioctl
 * @s: pointer to standard V4L2 device structure
 * @vc: standard V4L2 VIDIOC_G_CTRL ioctl structure
 *
 * If the requested control is supported, returns the control's current
 * value from the video_control[] array.  Otherwise, returns -EINVAL
 * if the control is not supported.
 */

static int ioctl_g_ctrl( struct v4l2_int_device * s, struct v4l2_control * vc )
{
	struct vcontrol *lvc;
	int i = 0;

	if ( !s || !vc )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	i = find_vctrl( vc->id );

	if ( i < 0 )
		return -EINVAL;

	lvc = &video_control[i];

	switch ( vc->id )
	{
	case V4L2_CID_BRIGHTNESS:
		vc->value = lvc->current_value;
		break;
	case V4L2_CID_CONTRAST:
		vc->value = lvc->current_value;
		break;
	case V4L2_CID_PRIVATE_BASE:
		vc->value = lvc->current_value;
		break;
	case V4L2_CID_VFLIP:
		vc->value = lvc->current_value;
		break;
	case V4L2_CID_HFLIP:
		vc->value = lvc->current_value;
		break;
	}

	return 0;
}

/*
 * ioctl_s_ctrl - V4L2 sensor interface handler for VIDIOC_S_CTRL ioctl
 * @s: pointer to standard V4L2 device structure
 * @vc: standard V4L2 VIDIOC_S_CTRL ioctl structure
 *
 * If the requested control is supported, sets the control's current
 * value in HW (and updates the video_control[] array).  Otherwise,
 * returns -EINVAL if the control is not supported.
 */
static int ioctl_s_ctrl( struct v4l2_int_device * s, struct v4l2_control * vc )
{

	int retval = -EINVAL;
	int i = 0;
	struct ov5642_sensor *sensor;
	struct vcontrol *lvc;

	PDEBUG("%s\n",__func__);

	if ( !s || !vc )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;

	i = find_vctrl( vc->id );
	if ( i < 0 )
	{
		return -EINVAL;
	}

	lvc = &video_control[i];

	switch ( vc->id )
	{
	case V4L2_CID_BRIGHTNESS:
		if ( vc->value >= 0 && vc->value <= 6 )
		{
			retval = ov5642_write_regs( brightness[vc->value] );
		}
		else
		{
			PDEBUG( "BRIGHTNESS LEVEL NOT SUPPORTED\n" );
			return -EINVAL;
		}
		break;

	case V4L2_CID_CONTRAST:
		if ( vc->value >= 0 && vc->value <= 6 )
		{
			retval = ov5642_write_regs( contrast[vc->value] );
		}
		else
		{
			PDEBUG( "CONTRAST LEVEL NOT SUPPORTED\n" );
			return -EINVAL;
		}
		break;

	case V4L2_CID_PRIVATE_BASE:
		if ( vc->value >= 0 && vc->value <= 2 )
		{
			retval = ov5642_write_regs( colors[vc->value] );
		}
		else
		{
			PDEBUG( "COLOR LEVEL NOT SUPPORTED\n" );
			return -EINVAL;
		}
		break;

	case V4L2_CID_VFLIP:
		if ( vc->value >= 0 )
		{

			unsigned int val = 0;
			val = (vc->value > 0) ? 1 : 0;
			retval = ov5642_set_v_flip( val );
		}
		else
		{
			PDEBUG( "VERTIVCAL FLIP INVALID VALUE\n" );
			return -EINVAL;
		}
		break;

	case V4L2_CID_HFLIP:
		if ( vc->value >= 0 )
		{
			unsigned int val = 0;
			val = (vc->value > 0) ? 1 : 0;
			retval = ov5642_set_h_flip( val );
		}
		else
		{
			PDEBUG( "HORIZONTAL FLIP INVALID VALUE\n" );
			return -EINVAL;
		}
		break;
	}

	if ( !retval )
		lvc->current_value = vc->value;

	return retval;
}

/*
 * ioctl_enum_fmt_cap - Implement the CAPTURE buffer VIDIOC_ENUM_FMT ioctl
 * @s: pointer to standard V4L2 device structure
 * @fmt: standard V4L2 VIDIOC_ENUM_FMT ioctl structure
 *
 * Implement the VIDIOC_ENUM_FMT ioctl for the CAPTURE buffer type.
 */
static int ioctl_enum_fmt_cap( struct v4l2_int_device * s, struct v4l2_fmtdesc * fmt )
{
	int index = 0;
	enum v4l2_buf_type type;

	if ( !s || !fmt )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	index = fmt->index;
	type = fmt->type;

	memset( fmt, 0, sizeof(*fmt) );
	fmt->index = index;
	fmt->type = type;

	switch ( fmt->type )
	{
	case V4L2_BUF_TYPE_VIDEO_CAPTURE:
		if ( index >= NUM_CAPTURE_FORMATS )
			return -EINVAL;
		break;

	default:
		return -EINVAL;
	}

	fmt->flags = ov5642_formats[index].flags;
	strlcpy( fmt->description, ov5642_formats[index].description, sizeof(fmt->description) );
	fmt->pixelformat = ov5642_formats[index].pixelformat;

	return 0;
}

/*
 * ioctl_try_fmt_cap - Implement the CAPTURE buffer VIDIOC_TRY_FMT ioctl
 * @s: pointer to standard V4L2 device structure
 * @f: pointer to standard V4L2 VIDIOC_TRY_FMT ioctl structure
 *
 * Implement the VIDIOC_TRY_FMT ioctl for the CAPTURE buffer type.  This
 * ioctl is used to negotiate the image capture size and pixel format
 * without actually making it take effect.
 */

static int ioctl_try_fmt_cap( struct v4l2_int_device * s, struct v4l2_format * f )
{
	int ifmt = 0;
	int ret;
	struct v4l2_pix_format *pix;

	if ( !s || !f )
	{
		PDEBUG("Invalid input\n");
		return -EINVAL;
	}

	pix = &f->fmt.pix;

	/* check resolution */
	ret = check_if_res_supported( pix->width, pix->height );

	if ( ret )
	{
		return ret;
	}

	for ( ifmt = 0; ifmt < NUM_CAPTURE_FORMATS; ifmt++ )
	{
		if ( pix->pixelformat == ov5642_formats[ifmt].pixelformat )
			break;
	}

	/* if no matching pixel format is found */
	if ( ifmt == NUM_CAPTURE_FORMATS )
	{
		return -EINVAL;
	}

	pix->pixelformat = ov5642_formats[ifmt].pixelformat;
	pix->field = V4L2_FIELD_NONE;
	pix->bytesperline = bytes_per_line( pix->width, pix->pixelformat );
	pix->sizeimage = image_size( pix->width, pix->height, pix->pixelformat );
	pix->priv = 0;

	switch ( pix->pixelformat )
	{
	case V4L2_PIX_FMT_NV16:
	case V4L2_PIX_FMT_NV61:
	case V4L2_PIX_FMT_NV12:
	case V4L2_PIX_FMT_NV21:
	case V4L2_PIX_FMT_YUYV:
	case V4L2_PIX_FMT_UYVY:
	default:
		pix->colorspace = V4L2_COLORSPACE_JPEG;
		break;

	case V4L2_PIX_FMT_SGRBG10:
	case V4L2_PIX_FMT_RGB565:
	case V4L2_PIX_FMT_RGB565X:
	case V4L2_PIX_FMT_RGB555:
	case V4L2_PIX_FMT_RGB555X:
		pix->colorspace = V4L2_COLORSPACE_SRGB;
		break;
	}

	return 0;
}

/*
 * ioctl_s_fmt_cap - V4L2 sensor interface handler for VIDIOC_S_FMT ioctl
 * @s: pointer to standard V4L2 device structure
 * @f: pointer to standard V4L2 VIDIOC_S_FMT ioctl structure
 *
 * If the requested format is supported, configures the HW to use that
 * format, returns error code if format not supported or HW can't be
 * correctly configured.
 */
static int ioctl_s_fmt_cap( struct v4l2_int_device * s, struct v4l2_format * f )
{
	struct ov5642_sensor *sensor;
	struct v4l2_pix_format *pix;
	int rval = 0;

	if ( !s || !f )
	{
		PDEBUG("Invalid input\n");
		return -EINVAL;
	}

	sensor = s->priv;
	pix = &f->fmt.pix;

	/* check that the format is valid */
	rval = ioctl_try_fmt_cap( s, f );

	if ( rval )
	{
		return rval;
	}

	/* set new format */
	sensor->pix = *pix;

	/* configure sensor for new format */
	ov5642_configure( s );

	return 0;
}

/*
 * ioctl_g_fmt_cap - V4L2 sensor interface handler for ioctl_g_fmt_cap
 * @s: pointer to standard V4L2 device structure
 * @f: pointer to standard V4L2 v4l2_format structure
 *
 * Returns the sensor's current pixel format in the v4l2_format
 * parameter.
 */
static int ioctl_g_fmt_cap( struct v4l2_int_device * s, struct v4l2_format * f )
{
	struct ov5642_sensor *sensor;

	if ( !s || !f )
	{
		PDEBUG("Invalid input\n");
		return -EINVAL;
	}

	sensor = s->priv;
	f->fmt.pix = sensor->pix;

	return 0;
}

/*
 * ioctl_g_parm - V4L2 sensor interface handler for VIDIOC_G_PARM ioctl
 * @s: pointer to standard V4L2 device structure
 * @a: pointer to standard V4L2 VIDIOC_G_PARM ioctl structure
 *
 * Returns the sensor's video CAPTURE parameters.
 */
static int ioctl_g_parm( struct v4l2_int_device * s, struct v4l2_streamparm * a )
{
	struct ov5642_sensor *sensor;
	struct v4l2_captureparm *cparm;

	if ( !s || !a )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;
	cparm = &a->parm.capture;

	if ( a->type != V4L2_BUF_TYPE_VIDEO_CAPTURE )
		return -EINVAL;

	memset( a, 0, sizeof(*a) );
	a->type = V4L2_BUF_TYPE_VIDEO_CAPTURE;

	cparm->capability = V4L2_CAP_TIMEPERFRAME;
	cparm->timeperframe = sensor->timeperframe;

	return 0;
}

/*
 * ioctl_s_parm - V4L2 sensor interface handler for VIDIOC_S_PARM ioctl
 * @s: pointer to standard V4L2 device structure
 * @a: pointer to standard V4L2 VIDIOC_S_PARM ioctl structure
 *
 * Configures the sensor to use the input parameters, if possible.  If
 * not possible, reverts to the old parameters and returns the
 * appropriate error code.
 */
static int ioctl_s_parm( struct v4l2_int_device * s, struct v4l2_streamparm * a )
{
	int rval = 0;
	struct ov5642_sensor *sensor;
	struct v4l2_fract *timeperframe;
	struct v4l2_fract timeperframe_old;
	int desired_fps = 0;
	enum ov5642_frameintervals_type fps = 0;

	PDEBUG("%s\n",__func__);

	if ( !s || !a )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;

	timeperframe = &a->parm.capture.timeperframe;
	timeperframe_old = sensor->timeperframe;
	sensor->timeperframe = *timeperframe;

	desired_fps = timeperframe->denominator / timeperframe->numerator;
	PDEBUG("desired_fps = %d denominator=%d numerator=%d \n",desired_fps , timeperframe->denominator , timeperframe->numerator );
	if ( (desired_fps < OV5642_MIN_FPS) || (desired_fps > OV5642_MAX_FPS) )
		return (-EINVAL);

	//	   if (sensor->mode->width > ov5642_resolutions[HD720P].width || sensor->mode->height > ov5642_resolutions[HD720P].height) {
	//               if (desired_fps > OV5642_MAX_FPS)
	//                       return -EINVAL;
	//       }

	rval = switch_fps( timeperframe, s, &fps );

	if ( rval )
		sensor->timeperframe = timeperframe_old;
	else
		*timeperframe = sensor->timeperframe;

	return rval;
}

/*
 * ioctl_g_priv - V4L2 sensor interface handler for vidioc_int_g_priv_num
 * @s: pointer to standard V4L2 device structure
 * @p: void pointer to hold sensor's private data address
 *
 * Returns device's (sensor's) private data area address in p parameter
 * We need the configure since we close the clk when going to Standby mode.
 */
static int ioctl_g_priv( struct v4l2_int_device * s, void * p )
{
	struct ov5642_sensor *sensor;
	if ( !s || !p )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}
	sensor = s->priv;

	/* copy data */
	memcpy( p,
			&(sensor->cam_port->hw_config),
			sizeof( struct dmw96cam_hw_config ) );

	return 0;
}

/*
 * reset_ov5642_to_default
 * @s: pointer to standard V4L2 device structure
 * Sets reset the device to default
 */
static void reset_ov5642_to_default( struct v4l2_int_device * s )
{
	// TODO

#if 0

	/* Reset */
	ov5642_write_reg(c, OV5642_SYS, 0x80);
	mdelay(10);

	reg = 0x1f;
	if (sensor->pdata->output_drive_capability)
	reg |= (sensor->pdata->output_drive_capability & 0x3) << 6;
	ov5642_write_reg(c, 0xc3, reg);
	ov5642_write_regs (c, ov5642_common);
#endif

	PDEBUG("SENSOR RESET\n");
}

/*
 * ioctl_s_power - V4L2 sensor interface handler for vidioc_int_s_power_num
 * @s: pointer to standard V4L2 device structure
 * @on: power state to which device is to be set
 *
 * Sets devices power state to requrested state, if possible.
 */
static int ioctl_s_power( struct v4l2_int_device * s, enum v4l2_power on )
{
	struct ov5642_sensor *sensor = s->priv;
	static enum v4l2_power prev_on = V4L2_POWER_OFF;

	int rval = 0;

	if ( on == V4L2_POWER_ON )
		PDEBUG("ov5642 = ON prev = %s \n", (prev_on == 0) ? "OFF" : (prev_on == 1) ? "ON" : "STANDBY" );
	else if ( on == V4L2_POWER_OFF )
		PDEBUG("ov5642 = OFF prev = %s \n", (prev_on == 0) ? "OFF" : (prev_on == 1) ? "ON" : "STANDBY" );
	else if ( on == V4L2_POWER_STANDBY )
		PDEBUG("ov5642 = STANDBY prev = %s \n", (prev_on == 0) ? "OFF" : (prev_on == 1) ? "ON" : "STANDBY" );

	if ( (prev_on == V4L2_POWER_ON) && (on == V4L2_POWER_STANDBY) )
	{
		ov5642_write_regs( ov5642_standby_on );
	}

	rval = dmw_camera_port_power_ctl( sensor->cam_port,
									  on );

	if ( rval < 0 )
	{
		PDEBUG( "Unable to set the power state: "
		OV5642_DRIVER_NAME " sensor\n" );

		return rval;
	}

	if ( (prev_on == V4L2_POWER_STANDBY) && (on == V4L2_POWER_ON) )
	{
		ov5642_write_regs( ov5642_standby_off );
	}

	/*
	 if (on == V4L2_POWER_ON)
	 sensor->pdata->set_xclk(xclk_current);
	 else
	 sensor->pdata->set_xclk(0);
	 */

	if ( (prev_on == V4L2_POWER_OFF && on == V4L2_POWER_ON) && (sensor->state == SENSOR_DETECTED) )
		reset_ov5642_to_default( s );

	if ( (prev_on == V4L2_POWER_STANDBY || prev_on == V4L2_POWER_ON) && (on == V4L2_POWER_ON) && (sensor->state == SENSOR_DETECTED) )
		ov5642_configure( s );

	if ( (on == V4L2_POWER_ON) && (sensor->state == SENSOR_NOT_DETECTED) )
	{
		rval = ov5642_detect();
		if ( rval < 0 )
		{
			PDEBUG( "Unable to detect "
			OV5642_DRIVER_NAME " sensor (or sensor is not connected)\n" );
			sensor->state = SENSOR_NOT_DETECTED;

			/* turn port off */
			dmw_camera_port_power_ctl( sensor->cam_port,
									   V4L2_POWER_OFF );

			return rval;
		}

		sensor->state = SENSOR_DETECTED;
		sensor->ver = rval;
		pr_info( OV5642_DRIVER_NAME " Chip version 0x%02x detected\n", sensor->ver );
		reset_ov5642_to_default( s );

		/* associate with port */
		dmw_camera_associate_sensor_with_port( ov5642.cam_port,
											   &ov5642_sensor_desc );
	}

	prev_on = on;
	return 0;
}

/*
 * ioctl_init - V4L2 sensor interface handler for VIDIOC_INT_INIT
 * @s: pointer to standard V4L2 device structure
 *
 * Initialize the sensor device (call ov5642_configure())
 */
static int ioctl_init( struct v4l2_int_device *s )
{
	return 0;
}

/**
 * ioctl_dev_exit - V4L2 sensor interface handler for vidioc_int_dev_exit_num
 * @s: pointer to standard V4L2 device structure
 *
 * Delinitialise the dev. at slave detach.  The complement of ioctl_dev_init.
 */
static int ioctl_dev_exit( struct v4l2_int_device *s )
{
	return 0;
}

/**
 * ioctl_dev_init - V4L2 sensor interface handler for vidioc_int_dev_init_num
 * @s: pointer to standard V4L2 device structure
 *
 * Initialise the device when slave attaches to the master.  Returns 0 if
 * ov5642 device could be found, otherwise returns appropriate error.
 */
static int ioctl_dev_init( struct v4l2_int_device *s )
{
	return 0;
}

/**
 * ioctl_enum_framesizes - V4L2 sensor if handler for vidioc_int_enum_framesizes
 * @s: pointer to standard V4L2 device structure
 * @frms: pointer to standard V4L2 framesizes enumeration structure
 *
 * Returns possible framesizes depending on choosen pixel format
 **/
static int ioctl_enum_framesizes( struct v4l2_int_device * s, struct v4l2_frmsizeenum * frms )
{
	int ifmt = 0;
	if ( !s || !frms )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	for ( ifmt = 0; ifmt < NUM_CAPTURE_FORMATS; ifmt++ )
	{
		if ( frms->pixel_format == ov5642_formats[ifmt].pixelformat )
			break;
	}

	/* Is requested pixelformat not found on sensor? */
	if ( ifmt == NUM_CAPTURE_FORMATS )
	{
		PDEBUG("sensor is not supporting the format\n");
		return -EINVAL;
	}

	if ( frms->index >= OV5642_NUM_MODES )
	{
		PDEBUG( "Invalid frame size or not supported by the sensor frms->index=0x%x NUM_DISCRETE_SIZES=%d\n", frms->index, OV5642_NUM_MODES );
		return -EINVAL;
	}

	frms->type = V4L2_FRMSIZE_TYPE_DISCRETE;
	frms->discrete.width = ov5642_modes[frms->index].width;
	frms->discrete.height = ov5642_modes[frms->index].height;

	return 0;
}

static int ioctl_enum_frameintervals( struct v4l2_int_device * s, struct v4l2_frmivalenum * frmi )
{
	int ifmt = 0;
	int ret;

	if ( !s || !frmi )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	for ( ifmt = 0; ifmt < NUM_CAPTURE_FORMATS; ifmt++ )
	{
		if ( frmi->pixel_format == ov5642_formats[ifmt].pixelformat )
			break;
	}
	/* Is requested pixelformat not found on sensor? */
	if ( ifmt == NUM_CAPTURE_FORMATS )
		return -EINVAL;

	ret = check_if_res_supported( frmi->width, frmi->height );

	if ( ret )
	{
		return ret;
	}

	if ( frmi->index >= NUM_TIMEFRAME_VALS || frmi->index > OV5642_30_FPS )
		return -EINVAL;

	frmi->type = V4L2_FRMIVAL_TYPE_DISCRETE;
	frmi->discrete.numerator = ov5642_frameintervals[frmi->index].numerator;
	frmi->discrete.denominator = ov5642_frameintervals[frmi->index].denominator;

	return 0;
}

static int ioctl_s_reg( struct v4l2_int_device * s, const struct v4l2_dbg_register * reg )
{
	struct ov5642_sensor *sensor;
	struct i2c_client *c;
	int ret;

	if ( !s || !reg || !s->priv )
		return -1;

	sensor = s->priv;

	PDEBUG("reg=%llx val=%llx\n", reg->reg , reg->val);

	c = dmw_camera_get_i2c( sensor->cam_port,
				 	 	 	&ov5642_sensor_desc );

	if ( !c )
	{
		return -EINVAL;
	}

	ret = ov5642_write_reg( c, reg->reg, reg->val );

	dmw_camera_put_i2c( ov5642.cam_port );

	return ret;
}

static int ioctl_g_reg( struct v4l2_int_device * s, struct v4l2_dbg_register * reg )
{
	struct ov5642_sensor *sensor;
	struct i2c_client *c;
	int ret;

	if ( !s || !reg || !s->priv )
		return -1;

	sensor = s->priv;

	c = dmw_camera_get_i2c( sensor->cam_port,
				 	 	 	&ov5642_sensor_desc );

	if ( !c )
	{
		return -EINVAL;
	}

	PDEBUG("reg=%llx val=%llx\n", reg->reg , reg->val);

	ret = ov5642_read_reg( c, 1, reg->reg, (unsigned long *) &(reg->val) );

	dmw_camera_put_i2c( ov5642.cam_port );

	return ret;
}

static struct v4l2_int_ioctl_desc ov5642_ioctl_desc[] =
{
       {vidioc_int_enum_framesizes_num,
         (v4l2_int_ioctl_func *)ioctl_enum_framesizes},
       {vidioc_int_enum_frameintervals_num,
         (v4l2_int_ioctl_func *)ioctl_enum_frameintervals},
       {vidioc_int_dev_init_num,
         (v4l2_int_ioctl_func *)ioctl_dev_init},
       {vidioc_int_dev_exit_num,
         (v4l2_int_ioctl_func *)ioctl_dev_exit},
       {vidioc_int_s_power_num,
         (v4l2_int_ioctl_func *)ioctl_s_power},
       {vidioc_int_g_priv_num,
         (v4l2_int_ioctl_func *)ioctl_g_priv},
       {vidioc_int_init_num,
         (v4l2_int_ioctl_func *)ioctl_init},
       {vidioc_int_enum_fmt_cap_num,
         (v4l2_int_ioctl_func *)ioctl_enum_fmt_cap},
       {vidioc_int_try_fmt_cap_num,
         (v4l2_int_ioctl_func *)ioctl_try_fmt_cap},
       {vidioc_int_g_fmt_cap_num,
         (v4l2_int_ioctl_func *)ioctl_g_fmt_cap},
       {vidioc_int_s_fmt_cap_num,
         (v4l2_int_ioctl_func *)ioctl_s_fmt_cap},
       {vidioc_int_g_parm_num,
         (v4l2_int_ioctl_func *)ioctl_g_parm},
       {vidioc_int_s_parm_num,
         (v4l2_int_ioctl_func *)ioctl_s_parm},
       {vidioc_int_queryctrl_num,
         (v4l2_int_ioctl_func *)ioctl_queryctrl},
       {vidioc_int_g_ctrl_num,
         (v4l2_int_ioctl_func *)ioctl_g_ctrl},
       {vidioc_int_s_ctrl_num,
         (v4l2_int_ioctl_func *)ioctl_s_ctrl},
       { vidioc_int_g_crop_num,
         (v4l2_int_ioctl_func *)ioctl_g_crop},
       {vidioc_int_s_crop_num,
         (v4l2_int_ioctl_func *)ioctl_s_crop},
       {vidioc_int_cropcap_num,
         (v4l2_int_ioctl_func *)ioctl_cropcap},
	   {vidioc_int_s_reg_num,
         (v4l2_int_ioctl_func *)ioctl_s_reg},
	   {vidioc_int_g_reg_num,
         (v4l2_int_ioctl_func *)ioctl_g_reg},
};


static struct v4l2_int_slave ov5642_slave =
{
	.ioctls = ov5642_ioctl_desc,
	.num_ioctls = ARRAY_SIZE( ov5642_ioctl_desc ),
};

static struct v4l2_int_device ov5642_int_device =
{
       .module = THIS_MODULE,
       .name   = OV5642_DRIVER_NAME,
       .priv   = &ov5642,
       .type   = v4l2_int_type_slave,
       .u      = {
               .slave = &ov5642_slave,
       },
};

/* probing function */
static int ov5642_probe( dmw_camera_sensor_desc_t * sensor_desc,
						 dmw_camera_port_t * 		cam_port )
{
	struct ov5642_sensor *sensor = &ov5642;
	int err = 0;

	/* associate camera port */
	sensor->cam_port = cam_port;

	sensor->v4l2_int_device = &ov5642_int_device;

	/* set default format */
	sensor->pix.width = ov5642_modes[0].width;
	sensor->pix.height = ov5642_modes[0].height;
	sensor->pix.pixelformat = V4L2_PIX_FMT_NV12;

	sensor->crop_rect.height = ov5642_modes[0].height;
	sensor->crop_rect.width = ov5642_modes[0].width;
	sensor->crop_rect.left = 0;
	sensor->crop_rect.top = 0;

	sensor->timeperframe.denominator = 15;
	sensor->timeperframe.numerator = 1;
	sensor->vflip = 0;
	sensor->hflip = 0;

	err = v4l2_int_device_register( sensor->v4l2_int_device );
	if ( err )
	{
		return err;
	}

	PDEBUG("\n\n\n P r o b i n g	OV5642	s e n s o r	 s u c c e s s   ! ! !\n\n\n");
	return 0;
}

/* sensor descriptor */
static dmw_camera_sensor_desc_t ov5642_sensor_desc =
{
 	 .name 	   = OV5642_DRIVER_NAME,
 	 .probe    = ov5642_probe,
 	 .i2c_addr = OV5642_I2C_ADDR,
 	 .mode	   = DMW_CAMERA_SENSOR_MODE_MIPI_1LANE,
};

/* default platform data, when no pdata is given by the board */
static dmw_camera_sensor_platform_data_t ov5642_default_platform_data =
{
 	 .__sensor_desc = &ov5642_sensor_desc,
};

static int __devinit ov5642_pdev_probe(struct platform_device *pdev)
{
	platform_set_drvdata(pdev, &ov5642_default_platform_data);

	return 0;
}

static int __devexit ov5642_pdev_remove(struct platform_device *pdev)
{
	return 0;
}

static struct platform_driver ov5642_driver = {
	.driver = {
		.name  = OV5642_DRIVER_NAME,
		.owner = THIS_MODULE,
	},
	.probe = ov5642_pdev_probe,
	.remove = __devexit_p(ov5642_pdev_remove),
};

static int __init ov5642_init(void)
{
	return platform_driver_register(&ov5642_driver);
}

static void __exit ov5642_exit(void)
{
	platform_driver_unregister(&ov5642_driver);
}

subsys_initcall(ov5642_init);

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("OV5642 camera sensor driver");
