/**\file
 *  The top most file which makes use of synopsys GMAC driver code.
 *
 *  This file can be treated as the example code for writing a application driver
 *  for synopsys GMAC device using the driver provided by Synopsys.
 *  This exmple is for Linux 2.6.xx kernel 
 *  - Uses 32 bit 33MHz PCI Interface as the host bus interface
 *  - Uses Linux network driver and the TCP/IP stack framework
 *  - Uses the Device Specific Synopsys GMAC Kernel APIs
 *  \internal
 * ---------------------------REVISION HISTORY--------------------------------
 * Synopsys 			01/Aug/2007			Created
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/errno.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/device.h>


#include <linux/platform_device.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>

#include "synopGMAC_Host.h"
#include "synopGMAC_banner.h"
#include "synopGMAC_plat.h"
#include "synopGMAC_apb_bus_interface.h"
#include "synopGMAC_network_interface.h"
#include "synopGMAC_Dev.h"


/****************************************************/


/* Global declarations: these are required to handle 
   Os and Platform dependent functionalities        */

/*GMAC IP Base address and Size   */
u8 *synopGMACMappedAddr = NULL;
u32 synopGMACMappedAddrSize = 0;

/*global adapter gmacdev pcidev and netdev pointers */
synopGMACNetworkAdapter	*synopGMACadapter;
synopGMACdevice			*synopGMACdev;
struct platform_device	*synopGMACapbdev;
struct net_device		*synopGMACnetdev;


/***************************************************/

int __init SynopGMAC_Host_Interface_init(void)
{
	int retval;

	printk("**********************************************************\n");
	printk("* Driver    :%s\n",synopGMAC_driver_string);
	printk("* Version   :%s\n",synopGMAC_driver_version);
	printk("* Copyright :%s\n",synopGMAC_copyright);
	printk("**********************************************************\n");

	TR0("Initializing synopsys GMAC interfaces ..\n") ;
	/* Initialize the bus interface*/
	if ((retval = synopGMAC_init_apb_bus_interface())) {
		printk("Could not initiliase the bus interface?\n");
		return retval;
	}

	/*Now we have got pdev structure from pci interface. Lets populate it in our global data structure*/	
	/* Initialize the Network dependent services */
	if((retval = synopGMAC_init_network_interface())){
		printk("Could not initialize the Network interface.\n");
		return retval;
	}
	
	return 0 ;
}

void __exit SynopGMAC_Host_Interface_exit(void)
{
	printk("Exiting synopsys GMAC interfaces ..\n") ;
	
	/* De-Initialize the Network dependent services */
	synopGMAC_exit_network_interface();
	printk("Exiting synopGMAC_exit_network_interface\n");
	
	/*De-Initialize the bus interface*/
	synopGMAC_exit_apb_bus_interface();
	printk("Exiting synpGMAC_exit_apb_bus_interface\n");
}

module_init(SynopGMAC_Host_Interface_init);
module_exit(SynopGMAC_Host_Interface_exit);

MODULE_AUTHOR("Synopsys India");
MODULE_LICENSE("GPL/BSD");
MODULE_DESCRIPTION("SYNOPSYS GMAC NETWORK DRIVER WITH PCI INTERFACE");

