/*
 * Copyright (c) 2011 DSP Group Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _LINUX_DWF_PLATFORM_H
#define _LINUX_DWF_PLATFORM_H

enum {
	DWF_RESOURCE_APB,
	DWF_RESOURCE_AHB,
	DWF_RESOURCE_ONCHIP,
	DWF_RESOURCE_IRQ,
};

#ifndef DW_CHIP_DW74
#define DW_CHIP_DW74	74
#endif

#ifndef DMW_CHIP_DMW96
#define DMW_CHIP_DMW96	96
#endif

struct dwf_platform_data {
	int chip;
	int board;
	void (*reset)(void);
	void (*busy)(void);
	void (*idle)(void);
};

#endif /* _LINUX_DWF_PLATFORM_H */
