/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.PsiElementWithOrigin;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightIdentifier;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B'\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/asJava/elements/KtLightIdentifier;", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/light/LightIdentifier;", "Lorg/jetbrains/kotlin/asJava/elements/PsiElementWithOrigin;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "lightOwner", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "name", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/psi/KtDeclaration;Ljava/lang/String;)V", "origin", "getOrigin", "()Lcom/intellij/psi/PsiElement;", "copy", "isPhysical", "", "getParent", "getContainingFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "getTextRange", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "getTextOffset", "", "equals", "other", "", "hashCode", "light-classes-base"})
public class KtLightIdentifier
extends LightIdentifier
implements PsiElementWithOrigin<PsiElement> {
    @NotNull
    private final PsiElement lightOwner;
    @Nullable
    private final KtDeclaration ktDeclaration;
    @Nullable
    private final String name;

    @JvmOverloads
    public KtLightIdentifier(@NotNull PsiElement lightOwner, @Nullable KtDeclaration ktDeclaration, @Nullable String name2) {
        Intrinsics.checkNotNullParameter((Object)lightOwner, (String)"lightOwner");
        super(lightOwner.getManager(), name2);
        this.lightOwner = lightOwner;
        this.ktDeclaration = ktDeclaration;
        this.name = name2;
    }

    public /* synthetic */ KtLightIdentifier(PsiElement psiElement, KtDeclaration ktDeclaration, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            KtDeclaration ktDeclaration2 = ktDeclaration;
            string2 = ktDeclaration2 != null ? ktDeclaration2.getName() : null;
        }
        this(psiElement, ktDeclaration, string2);
    }

    @Override
    @Nullable
    public PsiElement getOrigin() {
        PsiElement psiElement;
        KtDeclaration ktDeclaration = this.ktDeclaration;
        if (ktDeclaration instanceof KtSecondaryConstructor) {
            psiElement = ((KtSecondaryConstructor)this.ktDeclaration).getConstructorKeyword();
        } else if (ktDeclaration instanceof KtPrimaryConstructor) {
            psiElement = ((KtPrimaryConstructor)this.ktDeclaration).getConstructorKeyword();
            if (psiElement == null) {
                KtParameterList ktParameterList = ((KtPrimaryConstructor)this.ktDeclaration).getValueParameterList();
                if (ktParameterList != null) {
                    psiElement = ktParameterList;
                } else {
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(this.ktDeclaration);
                    psiElement = ktClassOrObject != null ? ktClassOrObject.getNameIdentifier() : null;
                }
            }
        } else {
            psiElement = ktDeclaration instanceof KtPropertyAccessor ? ((KtPropertyAccessor)this.ktDeclaration).getNamePlaceholder() : (ktDeclaration instanceof KtNamedDeclaration ? ((KtNamedDeclaration)this.ktDeclaration).getNameIdentifier() : null);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement copy() {
        return new KtLightIdentifier(this.getParent(), this.ktDeclaration, this.name);
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    @NotNull
    public PsiElement getParent() {
        return this.lightOwner;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile = this.lightOwner.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return psiFile;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        Object object = this.getOrigin();
        if (object == null || (object = object.getTextRange()) == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            object = textRange;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        }
        return object;
    }

    @Override
    public int getTextOffset() {
        PsiElement psiElement = this.getOrigin();
        return psiElement != null ? psiElement.getTextOffset() : -1;
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof KtLightIdentifier && Intrinsics.areEqual((Object)((KtLightIdentifier)other).lightOwner, (Object)this.lightOwner) && Intrinsics.areEqual((Object)((KtLightIdentifier)other).ktDeclaration, (Object)this.ktDeclaration) && Intrinsics.areEqual((Object)((KtLightIdentifier)other).name, (Object)this.name);
    }

    public int hashCode() {
        return this.lightOwner.hashCode();
    }

    @JvmOverloads
    public KtLightIdentifier(@NotNull PsiElement lightOwner, @Nullable KtDeclaration ktDeclaration) {
        Intrinsics.checkNotNullParameter((Object)lightOwner, (String)"lightOwner");
        this(lightOwner, ktDeclaration, null, 4, null);
    }
}

