/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenAttributesFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;

public class DefaultMavenAttributesFactory
implements MavenAttributesFactory {
    private final AttributesFactory delegate;
    private final NamedObjectInstantiator objectInstantiator;
    private final Map<List<Object>, ImmutableAttributes> concatCache = new ConcurrentHashMap<List<Object>, ImmutableAttributes>();

    public DefaultMavenAttributesFactory(AttributesFactory delegate, NamedObjectInstantiator objectInstantiator) {
        this.delegate = delegate;
        this.objectInstantiator = objectInstantiator;
    }

    public AttributeContainerInternal mutable() {
        return this.delegate.mutable();
    }

    public AttributeContainerInternal mutable(AttributeContainerInternal fallback) {
        return this.delegate.mutable(fallback);
    }

    public AttributeContainerInternal join(AttributeContainerInternal fallback, AttributeContainerInternal primary) {
        return this.delegate.join(fallback, primary);
    }

    public <T> ImmutableAttributes of(Attribute<T> key, T value) {
        return this.delegate.of(key, value);
    }

    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, T value) {
        return this.delegate.concat(node, key, value);
    }

    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, Isolatable<T> value) {
        return this.delegate.concat(node, key, value);
    }

    public ImmutableAttributes concat(ImmutableAttributes fallback, ImmutableAttributes primary) {
        return this.delegate.concat(fallback, primary);
    }

    public ImmutableAttributes safeConcat(ImmutableAttributes attributes1, ImmutableAttributes attributes2) throws AttributeMergingException {
        return this.delegate.safeConcat(attributes1, attributes2);
    }

    public ImmutableAttributes fromMap(Map<Attribute<?>, ?> attributes) {
        return this.delegate.fromMap(attributes);
    }

    @Override
    public ImmutableAttributes compileScope(ImmutableAttributes original) {
        ImmutableList key = ImmutableList.of((Object)original, (Object)"java-api");
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result = original;
            result = this.concat(result, (Attribute)USAGE_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("java-api", this.objectInstantiator));
            result = this.concat(result, (Attribute)FORMAT_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("jar", this.objectInstantiator));
            result = this.concat(result, (Attribute)CATEGORY_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("library", this.objectInstantiator));
            return result;
        });
    }

    @Override
    public ImmutableAttributes runtimeScope(ImmutableAttributes original) {
        ImmutableList key = ImmutableList.of((Object)original, (Object)"java-runtime");
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result = original;
            result = this.concat(result, (Attribute)USAGE_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("java-runtime", this.objectInstantiator));
            result = this.concat(result, (Attribute)FORMAT_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("jar", this.objectInstantiator));
            result = this.concat(result, (Attribute)CATEGORY_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("library", this.objectInstantiator));
            return result;
        });
    }

    @Override
    public ImmutableAttributes platformWithUsage(ImmutableAttributes original, String usage, boolean enforced) {
        String componentType = enforced ? "enforced-platform" : "platform";
        ImmutableList key = ImmutableList.of((Object)original, (Object)componentType, (Object)usage);
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result = original;
            result = this.concat(result, (Attribute)USAGE_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot(usage, this.objectInstantiator));
            result = this.concat(result, (Attribute)CATEGORY_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot(componentType, this.objectInstantiator));
            return result;
        });
    }

    @Override
    public ImmutableAttributes sourcesVariant(ImmutableAttributes original) {
        ImmutableList key = ImmutableList.of((Object)original, (Object)"documentation", (Object)"java-runtime", (Object)"sources");
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result = original;
            result = this.concat(result, (Attribute)CATEGORY_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("documentation", this.objectInstantiator));
            result = this.concat(result, Bundling.BUNDLING_ATTRIBUTE, (Bundling)this.objectInstantiator.named(Bundling.class, "external"));
            result = this.concat(result, DocsType.DOCS_TYPE_ATTRIBUTE, (DocsType)this.objectInstantiator.named(DocsType.class, "sources"));
            result = this.concat(result, (Attribute)USAGE_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("java-runtime", this.objectInstantiator));
            return result;
        });
    }

    @Override
    public ImmutableAttributes javadocVariant(ImmutableAttributes original) {
        ImmutableList key = ImmutableList.of((Object)original, (Object)"documentation", (Object)"java-runtime", (Object)"javadoc");
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result = original;
            result = this.concat(result, (Attribute)CATEGORY_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("documentation", this.objectInstantiator));
            result = this.concat(result, Bundling.BUNDLING_ATTRIBUTE, (Bundling)this.objectInstantiator.named(Bundling.class, "external"));
            result = this.concat(result, DocsType.DOCS_TYPE_ATTRIBUTE, (DocsType)this.objectInstantiator.named(DocsType.class, "javadoc"));
            result = this.concat(result, (Attribute)USAGE_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("java-runtime", this.objectInstantiator));
            return result;
        });
    }
}

