/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.services.internal;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public class BuildServiceDetails<T extends BuildService<P>, P extends BuildServiceParameters> {
    private final BuildIdentifier buildIdentifier;
    private final String name;
    private final Class<T> implementationType;
    private final P parameters;
    private final int maxUsages;
    private final boolean resolved;

    public BuildServiceDetails(BuildIdentifier buildIdentifier, String name, Class<T> implementationType, @Nullable P parameters, @Nullable Integer maxUsages) {
        this.buildIdentifier = buildIdentifier;
        this.name = name;
        this.implementationType = implementationType;
        this.parameters = parameters;
        this.maxUsages = maxUsages == null ? -1 : maxUsages;
        this.resolved = true;
    }

    public BuildServiceDetails(BuildIdentifier buildIdentifier, String name, Class<T> implementationType) {
        this.buildIdentifier = buildIdentifier;
        this.name = name;
        this.implementationType = implementationType;
        this.parameters = null;
        this.maxUsages = -1;
        this.resolved = false;
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getImplementationType() {
        return this.implementationType;
    }

    public P getParameters() {
        return this.parameters;
    }

    public int getMaxUsages() {
        return this.maxUsages;
    }

    public boolean isResolved() {
        return this.resolved;
    }
}

