/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.gradle.api.Incubating;
import org.gradle.api.file.Directory;
import org.gradle.buildinit.InsecureProtocolOption;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.jspecify.annotations.Nullable;

public class InitSettings {
    public static final String CONVENTION_PLUGIN_NAME_PREFIX = "buildlogic";
    private final BuildInitDsl dsl;
    private final boolean useIncubatingAPIs;
    private final String packageName;
    private final BuildInitTestFramework testFramework;
    private final String projectName;
    private final List<String> subprojects;
    private final ModularizationOption modularizationOption;
    private final Directory target;
    private final InsecureProtocolOption insecureProtocolOption;
    private final @Nullable JavaLanguageVersion javaLanguageVersion;
    private final boolean comments;

    public InitSettings(String projectName, boolean useIncubatingAPIs, List<String> subprojects, ModularizationOption modularizationOption, BuildInitDsl dsl, @Nullable String packageName, BuildInitTestFramework testFramework, Directory target) {
        this(projectName, useIncubatingAPIs, subprojects, modularizationOption, dsl, packageName, testFramework, InsecureProtocolOption.WARN, target, null, true);
    }

    public InitSettings(String projectName, boolean useIncubatingAPIs, List<String> subprojects, ModularizationOption modularizationOption, BuildInitDsl dsl, @Nullable String packageName, BuildInitTestFramework testFramework, InsecureProtocolOption insecureProtocolOption, Directory target, @Nullable JavaLanguageVersion javaLanguageVersion, boolean comments) {
        this.projectName = projectName;
        this.useIncubatingAPIs = useIncubatingAPIs;
        this.subprojects = InitSettings.getSubprojects(subprojects, modularizationOption);
        this.modularizationOption = modularizationOption;
        this.dsl = dsl;
        this.packageName = packageName;
        this.testFramework = testFramework;
        this.insecureProtocolOption = insecureProtocolOption;
        this.target = target;
        this.javaLanguageVersion = javaLanguageVersion;
        this.comments = comments;
    }

    private static List<String> getSubprojects(List<String> subprojects, ModularizationOption modularizationOption) {
        if (!subprojects.isEmpty() && modularizationOption == ModularizationOption.SINGLE_PROJECT) {
            return Collections.singletonList(subprojects.get(0));
        }
        return subprojects;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<String> getSubprojects() {
        return this.subprojects;
    }

    public ModularizationOption getModularizationOption() {
        return this.modularizationOption;
    }

    public BuildInitDsl getDsl() {
        return this.dsl;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public BuildInitTestFramework getTestFramework() {
        return this.testFramework;
    }

    public Directory getTarget() {
        return this.target;
    }

    public @Nullable InsecureProtocolOption getInsecureProtocolOption() {
        return this.insecureProtocolOption;
    }

    @Incubating
    public boolean isUseIncubatingAPIs() {
        return this.useIncubatingAPIs;
    }

    @Incubating
    public boolean isUseTestSuites() {
        return this.useIncubatingAPIs;
    }

    @Incubating
    public Optional<JavaLanguageVersion> getJavaLanguageVersion() {
        return Optional.ofNullable(this.javaLanguageVersion);
    }

    @Incubating
    public boolean isWithComments() {
        return this.comments;
    }
}

