/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GradleVersion;

public final class DefaultGradleVersion
extends GradleVersion {
    private static final Pattern VERSION_PATTERN = Pattern.compile("((\\d+)(\\.\\d+)+)(-(\\p{Alpha}+)-(\\w+))?(-(SNAPSHOT|\\d{14}([-+]\\d{4})?))?");
    private static final int STAGE_MILESTONE = 0;
    private static final int STAGE_UNKNOWN = 1;
    private static final int STAGE_PREVIEW = 2;
    private static final int STAGE_RC = 3;
    private final String version;
    private final int majorPart;
    private final String buildTime;
    private final String commitId;
    private final Long snapshot;
    private final String versionPart;
    private final Stage stage;
    private static final DefaultGradleVersion CURRENT;
    public static final String RESOURCE_NAME = "/org/gradle/build-receipt.properties";
    public static final String VERSION_OVERRIDE_VAR = "GRADLE_VERSION_OVERRIDE";
    public static final String VERSION_NUMBER_PROPERTY = "versionNumber";

    public static DefaultGradleVersion current() {
        return CURRENT;
    }

    public static DefaultGradleVersion version(String version) throws IllegalArgumentException {
        return new DefaultGradleVersion(version, null, null);
    }

    private DefaultGradleVersion(String version, String buildTime, String commitId) {
        this.version = version;
        this.buildTime = buildTime;
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid Gradle version string (examples: '9.0.0', '9.1.0-rc-1')", version));
        }
        this.versionPart = matcher.group(1);
        this.majorPart = Integer.parseInt(matcher.group(2), 10);
        this.commitId = this.setOrParseCommitId(commitId, matcher);
        this.stage = this.parseStage(matcher);
        this.snapshot = this.parseSnapshot(matcher);
    }

    private Long parseSnapshot(Matcher matcher) {
        if ("snapshot".equals(matcher.group(5)) || this.isCommitVersion(matcher)) {
            return 0L;
        }
        if (matcher.group(8) == null) {
            return null;
        }
        if ("SNAPSHOT".equals(matcher.group(8))) {
            return 0L;
        }
        try {
            if (matcher.group(9) != null) {
                return new SimpleDateFormat("yyyyMMddHHmmssZ").parse(matcher.group(8)).getTime();
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format.parse(matcher.group(8)).getTime();
        }
        catch (ParseException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private Stage parseStage(Matcher matcher) {
        if (matcher.group(4) == null || this.isCommitVersion(matcher)) {
            return null;
        }
        if (this.isStage("milestone", matcher)) {
            return Stage.from(0, matcher.group(6));
        }
        if (this.isStage("preview", matcher)) {
            return Stage.from(2, matcher.group(6));
        }
        if (this.isStage("rc", matcher)) {
            return Stage.from(3, matcher.group(6));
        }
        return Stage.from(1, matcher.group(6));
    }

    private boolean isCommitVersion(Matcher matcher) {
        return "commit".equals(matcher.group(5));
    }

    private boolean isStage(String stage, Matcher matcher) {
        return stage.equals(matcher.group(5));
    }

    private String setOrParseCommitId(String commitId, Matcher matcher) {
        if (commitId != null || !this.isCommitVersion(matcher)) {
            return commitId;
        }
        return matcher.group(6);
    }

    public String toString() {
        return "Gradle " + this.version;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int getMajorVersion() {
        return this.majorPart;
    }

    public String getBuildTimestamp() {
        return this.buildTime;
    }

    public String getGitRevision() {
        return this.commitId;
    }

    @Override
    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    @Override
    public GradleVersion getBaseVersion() {
        if (this.isFinal()) {
            return this;
        }
        return DefaultGradleVersion.version(this.versionPart);
    }

    @Override
    public boolean isFinal() {
        return this.stage == null && this.snapshot == null;
    }

    public DefaultGradleVersion getNextMajorVersion() {
        if (this.majorPart >= 8) {
            return DefaultGradleVersion.version(this.majorPart + 1 + ".0.0");
        }
        return DefaultGradleVersion.version(this.majorPart + 1 + ".0");
    }

    @Override
    public int compareTo(GradleVersion gv) {
        Long theirSnapshot;
        int diff;
        if (!(gv instanceof DefaultGradleVersion)) {
            throw new RuntimeException("Unexpected GradleVersion subclass: " + gv.getClass().getCanonicalName());
        }
        DefaultGradleVersion gradleVersion = (DefaultGradleVersion)gv;
        String[] majorVersionParts = this.versionPart.split("\\.");
        String[] otherMajorVersionParts = gradleVersion.versionPart.split("\\.");
        for (int i = 0; i < majorVersionParts.length && i < otherMajorVersionParts.length; ++i) {
            int otherPart;
            int part = Integer.parseInt(majorVersionParts[i]);
            if (part > (otherPart = Integer.parseInt(otherMajorVersionParts[i]))) {
                return 1;
            }
            if (otherPart <= part) continue;
            return -1;
        }
        if (majorVersionParts.length > otherMajorVersionParts.length) {
            return 1;
        }
        if (majorVersionParts.length < otherMajorVersionParts.length) {
            return -1;
        }
        if (this.stage != null && gradleVersion.stage != null && (diff = this.stage.compareTo(gradleVersion.stage)) != 0) {
            return diff;
        }
        if (this.stage == null && gradleVersion.stage != null) {
            return 1;
        }
        if (this.stage != null && gradleVersion.stage == null) {
            return -1;
        }
        Long thisSnapshot = this.snapshot == null ? Long.MAX_VALUE : this.snapshot;
        if (thisSnapshot.equals(theirSnapshot = Long.valueOf(gradleVersion.snapshot == null ? Long.MAX_VALUE : gradleVersion.snapshot))) {
            return this.version.compareTo(gradleVersion.version);
        }
        return thisSnapshot.compareTo(theirSnapshot);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        DefaultGradleVersion other = (DefaultGradleVersion)o;
        return this.version.equals(other.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        URL resource = DefaultGradleVersion.class.getResource(RESOURCE_NAME);
        if (resource == null) {
            throw new GradleException(String.format("Resource '%s' not found.", RESOURCE_NAME));
        }
        InputStream inputStream = null;
        try {
            URLConnection connection = resource.openConnection();
            connection.setUseCaches(false);
            inputStream = connection.getInputStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            String version = properties.get(VERSION_NUMBER_PROPERTY).toString();
            String overrideVersion = System.getenv(VERSION_OVERRIDE_VAR);
            if (overrideVersion != null) {
                version = overrideVersion;
            }
            String buildTimestamp = properties.get("buildTimestampIso").toString();
            String commitId = properties.get("commitId").toString();
            CURRENT = new DefaultGradleVersion(version, "unknown".equals(buildTimestamp) ? null : buildTimestamp, commitId);
            if (inputStream == null) return;
        }
        catch (Exception e) {
            try {
                throw new GradleException(String.format("Could not load version details from resource '%s'.", resource), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                IoActions.uncheckedClose(inputStream);
                throw throwable;
            }
        }
        IoActions.uncheckedClose(inputStream);
        return;
    }

    static final class Stage
    implements Comparable<Stage> {
        final int stage;
        final int number;
        final Character patchNo;

        private Stage(int stage, int number, Character patchNo) {
            this.stage = stage;
            this.number = number;
            this.patchNo = patchNo;
        }

        static Stage from(int stage, String stageString) {
            Matcher m = Pattern.compile("(\\d+)([a-z])?").matcher(stageString);
            if (!m.matches()) {
                return null;
            }
            int number = Integer.parseInt(m.group(1));
            if (m.groupCount() == 2 && m.group(2) != null) {
                return new Stage(stage, number, Character.valueOf(m.group(2).charAt(0)));
            }
            return new Stage(stage, number, Character.valueOf('_'));
        }

        @Override
        public int compareTo(Stage other) {
            if (this.stage > other.stage) {
                return 1;
            }
            if (this.stage < other.stage) {
                return -1;
            }
            if (this.number > other.number) {
                return 1;
            }
            if (this.number < other.number) {
                return -1;
            }
            if (this.patchNo.charValue() > other.patchNo.charValue()) {
                return 1;
            }
            if (this.patchNo.charValue() < other.patchNo.charValue()) {
                return -1;
            }
            return 0;
        }
    }
}

