/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.Loader;
import org.mortbay.xml.XmlParser;

public class TagLibConfiguration
implements Configuration {
    WebAppContext _context;

    public void setWebAppContext(WebAppContext context) {
        this._context = context;
    }

    public WebAppContext getWebAppContext() {
        return this._context;
    }

    public void configureClassLoader() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configureWebApp() throws Exception {
        String no_TLD_attr;
        Resource web_inf;
        HashSet<Resource> tlds = new HashSet<Resource>();
        HashSet<String> jars = new HashSet<String>();
        if (this._context.getResourceAliases() != null && this._context.getBaseResource() != null && this._context.getBaseResource().exists()) {
            Iterator iter = this._context.getResourceAliases().values().iterator();
            while (iter.hasNext()) {
                String location = (String)iter.next();
                if (location == null || !location.toLowerCase().endsWith(".tld")) continue;
                if (!location.startsWith("/")) {
                    location = "/WEB-INF/" + location;
                }
                Resource l = this._context.getBaseResource().addPath(location);
                tlds.add(l);
            }
        }
        if ((web_inf = this._context.getWebInf()) != null) {
            String[] contents = web_inf.list();
            for (int i = 0; contents != null && i < contents.length; ++i) {
                if (contents[i] == null || !contents[i].toLowerCase().endsWith(".tld")) continue;
                Resource l = this._context.getWebInf().addPath(contents[i]);
                tlds.add(l);
            }
        }
        Pattern no_TLD_pattern = (no_TLD_attr = this._context.getInitParameter("org.mortbay.jetty.webapp.NoTLDJarPattern")) == null ? null : Pattern.compile(no_TLD_attr);
        boolean parent = false;
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            URL[] urls;
            if (loader instanceof URLClassLoader && (urls = ((URLClassLoader)loader).getURLs()) != null) {
                for (int i = 0; i < urls.length; ++i) {
                    Object var19_28;
                    if (!urls[i].toString().toLowerCase().endsWith(".jar")) continue;
                    String jar = urls[i].toString();
                    int slash = jar.lastIndexOf(47);
                    jar = jar.substring(slash + 1);
                    if (parent && (!this._context.isParentLoaderPriority() && jars.contains(jar) || no_TLD_pattern != null && no_TLD_pattern.matcher(jar).matches())) continue;
                    jars.add(jar);
                    Log.debug("TLD search of {}", urls[i]);
                    File file = Resource.newResource(urls[i]).getFile();
                    if (file == null || !file.exists() || !file.canRead()) continue;
                    JarFile jarfile = null;
                    try {
                        try {
                            jarfile = new JarFile(file);
                            Enumeration<JarEntry> e = jarfile.entries();
                            while (e.hasMoreElements()) {
                                ZipEntry entry = e.nextElement();
                                String name = entry.getName();
                                if (!name.startsWith("META-INF/") || !name.toLowerCase().endsWith(".tld")) continue;
                                Resource tld = Resource.newResource("jar:" + urls[i] + "!/" + name);
                                tlds.add(tld);
                                Log.debug("TLD found {}", tld);
                            }
                            var19_28 = null;
                            if (jarfile == null) continue;
                        }
                        catch (Exception e) {
                            Log.warn("Failed to read file: " + file, e);
                            var19_28 = null;
                            if (jarfile == null) continue;
                            jarfile.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var19_28 = null;
                        if (jarfile != null) {
                            jarfile.close();
                        }
                        throw throwable;
                    }
                    jarfile.close();
                }
            }
            parent = true;
        }
        XmlParser parser = new XmlParser(false);
        parser.redirectEntity("web-jsptaglib_1_1.dtd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", false));
        parser.redirectEntity("web-jsptaglib_1_2.dtd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", false));
        parser.redirectEntity("web-jsptaglib_2_0.xsd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", false));
        parser.redirectEntity("web-jsptaglibrary_1_1.dtd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", false));
        parser.redirectEntity("web-jsptaglibrary_1_2.dtd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", false));
        parser.redirectEntity("web-jsptaglibrary_2_0.xsd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", false));
        parser.setXpath("/taglib/listener/listener-class");
        Iterator iter = tlds.iterator();
        block16: while (iter.hasNext()) {
            try {
                XmlParser.Node root;
                Resource tld = (Resource)iter.next();
                if (Log.isDebugEnabled()) {
                    Log.debug("TLD=" + tld);
                }
                try {
                    root = parser.parse(tld.getInputStream());
                }
                catch (Exception e) {
                    root = parser.parse(tld.getURL().toString());
                }
                if (root == null) {
                    Log.warn("No TLD root in {}", tld);
                    continue;
                }
                int i = 0;
                while (true) {
                    XmlParser.Node node;
                    if (i >= root.size()) continue block16;
                    Object o = root.get(i);
                    if (o instanceof XmlParser.Node && "listener".equals((node = (XmlParser.Node)o).getTag())) {
                        String className = node.getString("listener-class", false, true);
                        if (Log.isDebugEnabled()) {
                            Log.debug("listener=" + className);
                        }
                        try {
                            Class listenerClass = this.getWebAppContext().loadClass(className);
                            EventListener l = (EventListener)listenerClass.newInstance();
                            this._context.addEventListener(l);
                        }
                        catch (Exception e) {
                            Log.warn("Could not instantiate listener " + className + ": " + e);
                            Log.debug(e);
                        }
                        catch (Error e) {
                            Log.warn("Could not instantiate listener " + className + ": " + e);
                            Log.debug(e);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Log.warn(e);
                continue;
            }
            break;
        }
        return;
    }

    public void deconfigureWebApp() throws Exception {
    }
}

