/* softPromoter.c was originally generated by the autoSql program, which also 
 * generated softPromoter.h and softPromoter.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "jksql.h"
#include "softPromoter.h"


void softPromoterStaticLoad(char **row, struct softPromoter *ret)
/* Load a row from softPromoter table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
ret->type = row[5];
ret->origScore = atof(row[6]);
ret->origName = row[7];
ret->blockString = row[8];
}

struct softPromoter *softPromoterLoad(char **row)
/* Load a softPromoter from row fetched with select * from softPromoter
 * from database.  Dispose of this with softPromoterFree(). */
{
struct softPromoter *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
ret->type = cloneString(row[5]);
ret->origScore = atof(row[6]);
ret->origName = cloneString(row[7]);
ret->blockString = cloneString(row[8]);
return ret;
}

struct softPromoter *softPromoterLoadAll(char *fileName) 
/* Load all softPromoter from a tab-separated file.
 * Dispose of this with softPromoterFreeList(). */
{
struct softPromoter *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = softPromoterLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct softPromoter *softPromoterCommaIn(char **pS, struct softPromoter *ret)
/* Create a softPromoter out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new softPromoter */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
ret->type = sqlStringComma(&s);
ret->origScore = sqlSignedComma(&s);
ret->origName = sqlStringComma(&s);
ret->blockString = sqlStringComma(&s);
*pS = s;
return ret;
}

void softPromoterFree(struct softPromoter **pEl)
/* Free a single dynamically allocated softPromoter such as created
 * with softPromoterLoad(). */
{
struct softPromoter *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->type);
freeMem(el->origName);
freeMem(el->blockString);
freez(pEl);
}

void softPromoterFreeList(struct softPromoter **pList)
/* Free a list of dynamically allocated softPromoter's */
{
struct softPromoter *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    softPromoterFree(&el);
    }
*pList = NULL;
}

void softPromoterOutput(struct softPromoter *el, FILE *f, char sep, char lastSep) 
/* Print out softPromoter.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->origScore);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->origName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->blockString);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

